/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.helpers.Numbers;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalFlushableChannel;
import org.neo4j.unsafe.impl.batchimport.input.ByteBufferFlushableChannel;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.InputCache;
import org.neo4j.unsafe.impl.batchimport.input.InputCacher;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityVisitor;
import org.neo4j.unsafe.impl.batchimport.input.ValueType;

abstract class InputEntityCacheWriter
implements InputCacher {
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected final StoreChannel channel;
    private final ByteBuffer chunkHeaderChannel = InputCache.newChunkHeaderBuffer();
    private final FlushableChannel header;
    private final int chunkSize;
    private final int[] nextKeyId = new int[4];
    private final int[] maxKeyId = new int[4];
    private final Map<String, Integer>[] tokens = new Map[4];

    protected InputEntityCacheWriter(StoreChannel channel, StoreChannel header, RecordFormats recordFormats, int chunkSize) {
        this.chunkSize = chunkSize;
        this.initMaxTokenKeyIds(recordFormats);
        this.channel = channel;
        this.header = new PhysicalFlushableChannel(header);
        for (int i = 0; i < this.tokens.length; ++i) {
            this.tokens[i] = new ConcurrentHashMap<String, Integer>();
        }
    }

    @Override
    public final synchronized InputEntityVisitor wrap(InputEntityVisitor visitor) {
        return this.instantiateWrapper(visitor, this.chunkSize);
    }

    protected abstract SerializingInputEntityVisitor instantiateWrapper(InputEntityVisitor var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeChunk(ByteBuffer buffer) throws IOException {
        long dataStartPosition;
        InputEntityCacheWriter inputEntityCacheWriter = this;
        synchronized (inputEntityCacheWriter) {
            int chunkLength = buffer.limit();
            this.chunkHeaderChannel.clear();
            this.chunkHeaderChannel.putInt(chunkLength);
            this.chunkHeaderChannel.flip();
            this.channel.writeAll(this.chunkHeaderChannel);
            dataStartPosition = this.channel.position();
            this.channel.position(dataStartPosition + (long)chunkLength);
        }
        this.channel.writeAll(buffer, dataStartPosition);
    }

    @Override
    public void close() throws IOException {
        this.header.put((byte)-2);
        this.writeChunk(ByteBuffer.wrap(new byte[0]));
        this.channel.close();
        this.header.close();
    }

    private void initMaxTokenKeyIds(RecordFormats recordFormats) {
        this.maxKeyId[0] = InputEntityCacheWriter.getMaxAcceptableTokenId(recordFormats.propertyKeyToken().getMaxId());
        this.maxKeyId[1] = InputEntityCacheWriter.getMaxAcceptableTokenId(recordFormats.labelToken().getMaxId());
        this.maxKeyId[2] = InputEntityCacheWriter.getMaxAcceptableTokenId(recordFormats.relationshipTypeToken().getMaxId());
        this.maxKeyId[3] = InputEntityCacheWriter.getMaxAcceptableTokenId(recordFormats.relationshipGroup().getMaxId());
    }

    private static int getMaxAcceptableTokenId(long maxId) {
        return (int)Math.min(Integer.MAX_VALUE, maxId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getOrCreateToken(byte type, String key) throws IOException {
        Integer id = this.tokens[type].get(key);
        if (id == null) {
            FlushableChannel flushableChannel = this.header;
            synchronized (flushableChannel) {
                id = this.tokens[type].get(key);
                if (id == null) {
                    if (this.nextKeyId[type] == this.maxKeyId[type]) {
                        throw new UnsupportedOperationException("Too many tokens. Creation of more then " + this.maxKeyId[type] + " tokens is not supported.");
                    }
                    byte by = type;
                    int n = this.nextKeyId[by];
                    this.nextKeyId[by] = n + 1;
                    id = n;
                    this.tokens[type].put(key, id);
                    this.header.put(type);
                    ValueType.stringType().write(key, this.header);
                }
            }
        }
        return id;
    }

    abstract class SerializingInputEntityVisitor
    extends InputEntity {
        private final int lengthThreshold;
        private byte[] array;
        protected ByteBuffer buffer;
        private FlushableChannel bufferAsChannel;
        private final int[] previousGroupIds;

        SerializingInputEntityVisitor(InputEntityVisitor actual, int chunkSize) {
            super(actual);
            this.previousGroupIds = new int[2];
            this.lengthThreshold = chunkSize;
            this.array = new byte[chunkSize + chunkSize / 10];
            this.buffer = ByteBuffer.wrap(this.array);
            this.bufferAsChannel = new ByteBufferFlushableChannel(this.buffer);
        }

        @Override
        public void endOfEntity() throws IOException {
            super.endOfEntity();
            this.serializeEntity();
            if (this.buffer.position() >= this.lengthThreshold) {
                this.flushChunk();
                this.clearState();
            }
        }

        protected void clearState() {
            Arrays.fill(this.previousGroupIds, Group.GLOBAL.id());
        }

        protected abstract void serializeEntity() throws IOException;

        protected void writeProperties() throws IOException {
            if (this.hasPropertyId) {
                this.buffer(10).putShort((short)-1).putLong(this.propertyId);
            } else {
                Object[] properties = this.properties();
                this.buffer(2).putShort(Numbers.safeCastLongToShort((long)(properties.length / 2)));
                for (int i = 0; i < properties.length; ++i) {
                    Object key = properties[i++];
                    Object value = properties[i];
                    if (value == null) continue;
                    this.writeToken((byte)0, key);
                    this.writeValue(value);
                }
            }
        }

        protected ByteBuffer buffer(int requiredSpace) {
            int position = this.buffer.position();
            if (position + requiredSpace >= this.buffer.capacity()) {
                this.array = Arrays.copyOf(this.array, Integer.max(this.array.length * 2, position + requiredSpace));
                this.buffer = ByteBuffer.wrap(this.array);
                this.buffer.position(position);
                this.bufferAsChannel = new ByteBufferFlushableChannel(this.buffer);
            }
            return this.buffer;
        }

        protected void writeGroup(Group group, int slot) throws IOException {
            Group group2 = group = group != null ? group : Group.GLOBAL;
            if (group.id() == this.previousGroupIds[slot]) {
                this.buffer(1).put((byte)0);
            } else {
                this.previousGroupIds[slot] = group.id();
                this.buffer(5).put((byte)1).putInt(this.previousGroupIds[slot]);
                this.writeToken((byte)3, group.name());
            }
        }

        protected void writeValue(Object value) throws IOException {
            ValueType type = ValueType.typeOf(value);
            int length = type.length(value);
            this.buffer(1 + length).put(type.id());
            type.write(value, this.bufferAsChannel);
        }

        protected void writeToken(byte type, Object key) throws IOException {
            if (key instanceof String) {
                int id = InputEntityCacheWriter.this.getOrCreateToken(type, (String)key);
                this.buffer(4).putInt(id);
            } else if (key instanceof Integer) {
                this.buffer(8).putInt(-1).putInt((Integer)key);
            } else {
                throw new IllegalArgumentException("Invalid key " + key + ", " + key.getClass());
            }
        }

        @Override
        public void close() throws IOException {
            if (this.buffer.position() > 0) {
                this.flushChunk();
            }
        }

        private void flushChunk() throws IOException {
            this.buffer(2).putShort((short)-3);
            this.buffer.flip();
            InputEntityCacheWriter.this.writeChunk(this.buffer);
            this.buffer.clear();
        }
    }
}

