/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongList;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.SpatialSchemaKey;
import org.neo4j.values.storable.Value;

class SpatialVerifyDeferredConstraint {
    SpatialVerifyDeferredConstraint() {
    }

    static void verify(PropertyAccessor nodePropertyAccessor, Layout<SpatialSchemaKey, NativeSchemaValue> layout, GBPTree<SpatialSchemaKey, NativeSchemaValue> tree, SchemaIndexDescriptor descriptor) throws IndexEntryConflictException {
        SpatialSchemaKey from = (SpatialSchemaKey)((Object)layout.newKey());
        SpatialSchemaKey to = (SpatialSchemaKey)((Object)layout.newKey());
        SpatialVerifyDeferredConstraint.initializeKeys(from, to);
        try (RawCursor seek = tree.seek((Object)from, (Object)to);){
            SpatialVerifyDeferredConstraint.scanAndVerifyDuplicates(nodePropertyAccessor, descriptor, (RawCursor<Hit<SpatialSchemaKey, NativeSchemaValue>, IOException>)seek);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void scanAndVerifyDuplicates(PropertyAccessor nodePropertyAccessor, SchemaIndexDescriptor descriptor, RawCursor<Hit<SpatialSchemaKey, NativeSchemaValue>, IOException> seek) throws IOException, IndexEntryConflictException {
        Hit hit;
        PrimitiveLongList nodesWithCollidingPoints = Primitive.longList();
        long prevRawBits = Long.MIN_VALUE;
        if (seek.next()) {
            hit = (Hit)seek.get();
            prevRawBits = ((SpatialSchemaKey)((Object)hit.key())).rawValueBits;
            nodesWithCollidingPoints.add(((SpatialSchemaKey)((Object)hit.key())).getEntityId());
        }
        while (seek.next()) {
            hit = (Hit)seek.get();
            SpatialSchemaKey key = (SpatialSchemaKey)((Object)hit.key());
            long currentRawBits = key.rawValueBits;
            long currentNodeId = key.getEntityId();
            if (prevRawBits != currentRawBits) {
                if (nodesWithCollidingPoints.size() > 1) {
                    SpatialVerifyDeferredConstraint.verifyConstraintOn(nodesWithCollidingPoints, nodePropertyAccessor, descriptor);
                }
                nodesWithCollidingPoints.clear();
            }
            nodesWithCollidingPoints.add(currentNodeId);
            prevRawBits = currentRawBits;
        }
        if (nodesWithCollidingPoints.size() > 1) {
            SpatialVerifyDeferredConstraint.verifyConstraintOn(nodesWithCollidingPoints, nodePropertyAccessor, descriptor);
        }
    }

    private static void verifyConstraintOn(PrimitiveLongList nodeIds, PropertyAccessor nodePropertyAccessor, SchemaIndexDescriptor descriptor) throws IndexEntryConflictException {
        HashMap<Value, Long> points = new HashMap<Value, Long>();
        PrimitiveLongIterator iter = nodeIds.iterator();
        try {
            while (iter.hasNext()) {
                long id = iter.next();
                Value value = nodePropertyAccessor.getPropertyValue(id, descriptor.schema().getPropertyId());
                Long other = (Long)points.get(value);
                if (other == null) {
                    points.put(value, id);
                    other = id;
                }
                if (other == id) continue;
                throw new IndexEntryConflictException((long)other, id, value);
            }
        }
        catch (EntityNotFoundException e) {
            throw new RuntimeException("Failed to validate uniqueness constraint", e);
        }
    }

    private static void initializeKeys(SpatialSchemaKey from, SpatialSchemaKey to) {
        from.initialize(Long.MIN_VALUE);
        to.initialize(Long.MAX_VALUE);
        from.initValueAsLowest();
        to.initValueAsHighest();
    }
}

