/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.nio.ByteBuffer;
import org.neo4j.helpers.Numbers;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptorFactory;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.string.UTF8;

public class SchemaRuleDeserializer2_0to3_1 {
    private static final Long NO_OWNED_INDEX_RULE = null;
    private static final long NO_OWNING_CONSTRAINT = -1L;

    private SchemaRuleDeserializer2_0to3_1() {
    }

    static boolean isLegacySchemaRule(byte schemaRuleType) {
        return schemaRuleType >= 1 && schemaRuleType <= SchemaRule.Kind.values().length;
    }

    static SchemaRule deserialize(long id, int labelId, byte kindByte, ByteBuffer buffer) throws MalformedSchemaRuleException {
        SchemaRule.Kind kind = SchemaRule.Kind.forId(kindByte);
        try {
            SchemaRule rule = SchemaRuleDeserializer2_0to3_1.newRule(kind, id, labelId, buffer);
            if (null == rule) {
                throw new MalformedSchemaRuleException(null, "Deserialized null schema rule for id %d with kind %s", id, kind.name());
            }
            return rule;
        }
        catch (Exception e) {
            throw new MalformedSchemaRuleException(e, "Could not deserialize schema rule for id %d with kind %s", id, kind.name());
        }
    }

    private static SchemaRule newRule(SchemaRule.Kind kind, long id, int labelId, ByteBuffer buffer) {
        switch (kind) {
            case INDEX_RULE: {
                return SchemaRuleDeserializer2_0to3_1.readIndexRule(id, false, labelId, buffer);
            }
            case CONSTRAINT_INDEX_RULE: {
                return SchemaRuleDeserializer2_0to3_1.readIndexRule(id, true, labelId, buffer);
            }
            case UNIQUENESS_CONSTRAINT: {
                return SchemaRuleDeserializer2_0to3_1.readUniquenessConstraintRule(id, labelId, buffer);
            }
            case NODE_PROPERTY_EXISTENCE_CONSTRAINT: {
                return SchemaRuleDeserializer2_0to3_1.readNodePropertyExistenceConstraintRule(id, labelId, buffer);
            }
            case RELATIONSHIP_PROPERTY_EXISTENCE_CONSTRAINT: {
                return SchemaRuleDeserializer2_0to3_1.readRelPropertyExistenceConstraintRule(id, labelId, buffer);
            }
        }
        throw new IllegalArgumentException(kind.name());
    }

    private static IndexRule readIndexRule(long id, boolean constraintIndex, int label, ByteBuffer serialized) {
        IndexProvider.Descriptor providerDescriptor = SchemaRuleDeserializer2_0to3_1.readIndexProviderDescriptor(serialized);
        int[] propertyKeyIds = SchemaRuleDeserializer2_0to3_1.readIndexPropertyKeys(serialized);
        SchemaIndexDescriptor descriptor = constraintIndex ? SchemaIndexDescriptorFactory.uniqueForLabel(label, propertyKeyIds) : SchemaIndexDescriptorFactory.forLabel(label, propertyKeyIds);
        long owningConstraint = constraintIndex ? SchemaRuleDeserializer2_0to3_1.readOwningConstraint(serialized) : -1L;
        return new IndexRule(id, providerDescriptor, descriptor, owningConstraint);
    }

    private static IndexProvider.Descriptor readIndexProviderDescriptor(ByteBuffer serialized) {
        String providerKey = UTF8.getDecodedStringFrom((ByteBuffer)serialized);
        String providerVersion = UTF8.getDecodedStringFrom((ByteBuffer)serialized);
        return new IndexProvider.Descriptor(providerKey, providerVersion);
    }

    private static int[] readIndexPropertyKeys(ByteBuffer serialized) {
        int count = serialized.getShort();
        assert (count >= 1);
        int[] props = new int[count];
        for (int i = 0; i < count; ++i) {
            props[i] = Numbers.safeCastLongToInt((long)serialized.getLong());
        }
        return props;
    }

    private static long readOwningConstraint(ByteBuffer serialized) {
        return serialized.getLong();
    }

    public static ConstraintRule readUniquenessConstraintRule(long id, int labelId, ByteBuffer buffer) {
        return new ConstraintRule(id, ConstraintDescriptorFactory.uniqueForLabel(labelId, SchemaRuleDeserializer2_0to3_1.readConstraintPropertyKeys(buffer)), SchemaRuleDeserializer2_0to3_1.readOwnedIndexRule(buffer));
    }

    public static ConstraintRule readNodePropertyExistenceConstraintRule(long id, int labelId, ByteBuffer buffer) {
        return new ConstraintRule(id, ConstraintDescriptorFactory.existsForLabel(labelId, SchemaRuleDeserializer2_0to3_1.readPropertyKey(buffer)), NO_OWNED_INDEX_RULE);
    }

    public static ConstraintRule readRelPropertyExistenceConstraintRule(long id, int relTypeId, ByteBuffer buffer) {
        return new ConstraintRule(id, ConstraintDescriptorFactory.existsForRelType(relTypeId, SchemaRuleDeserializer2_0to3_1.readPropertyKey(buffer)), NO_OWNED_INDEX_RULE);
    }

    private static int readPropertyKey(ByteBuffer buffer) {
        return buffer.getInt();
    }

    private static int[] readConstraintPropertyKeys(ByteBuffer buffer) {
        int[] keys = new int[buffer.get()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = Numbers.safeCastLongToInt((long)buffer.getLong());
        }
        return keys;
    }

    private static Long readOwnedIndexRule(ByteBuffer buffer) {
        return buffer.getLong();
    }
}

