/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.standard;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.format.BaseOneByteHeaderRecordFormat;
import org.neo4j.kernel.impl.store.format.BaseRecordFormat;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;

public class NodeRecordFormat
extends BaseOneByteHeaderRecordFormat<NodeRecord> {
    public static final int RECORD_SIZE = 15;

    public NodeRecordFormat() {
        super(NodeRecordFormat.fixedRecordSize(15), 0, 1, 35);
    }

    @Override
    public NodeRecord newRecord() {
        return new NodeRecord(-1L);
    }

    @Override
    public void read(NodeRecord record, PageCursor cursor, RecordLoad mode, int recordSize) {
        byte headerByte = cursor.getByte();
        boolean inUse = this.isInUse(headerByte);
        record.setInUse(inUse);
        if (mode.shouldLoad(inUse)) {
            long nextRel = (long)cursor.getInt() & 0xFFFFFFFFL;
            long nextProp = (long)cursor.getInt() & 0xFFFFFFFFL;
            long relModifier = ((long)headerByte & 0xEL) << 31;
            long propModifier = ((long)headerByte & 0xF0L) << 28;
            long lsbLabels = (long)cursor.getInt() & 0xFFFFFFFFL;
            long hsbLabels = cursor.getByte() & 0xFF;
            long labels = lsbLabels | hsbLabels << 32;
            byte extra = cursor.getByte();
            boolean dense = (extra & 1) > 0;
            record.initialize(inUse, BaseRecordFormat.longFromIntAndMod(nextProp, propModifier), dense, BaseRecordFormat.longFromIntAndMod(nextRel, relModifier), labels);
        }
    }

    @Override
    public void write(NodeRecord record, PageCursor cursor, int recordSize) {
        if (record.inUse()) {
            long nextRel = record.getNextRel();
            long nextProp = record.getNextProp();
            short relModifier = nextRel == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? (short)0 : (short)((nextRel & 0x700000000L) >> 31);
            int propModifier = (short)(nextProp == (long)Record.NO_NEXT_PROPERTY.intValue() ? 0 : (short)((nextProp & 0xF00000000L) >> 28));
            short inUseUnsignedByte = (record.inUse() ? Record.IN_USE : Record.NOT_IN_USE).byteValue();
            inUseUnsignedByte = (short)(inUseUnsignedByte | relModifier | propModifier);
            cursor.putByte((byte)inUseUnsignedByte);
            cursor.putInt((int)nextRel);
            cursor.putInt((int)nextProp);
            long labelField = record.getLabelField();
            cursor.putInt((int)labelField);
            cursor.putByte((byte)((labelField & 0xFF00000000L) >> 32));
            byte extra = record.isDense() ? (byte)1 : 0;
            cursor.putByte(extra);
        } else {
            this.markAsUnused(cursor);
        }
    }
}

