/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.function.Function;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.values.storable.ValueGroup;

public class FusionSlotSelector20
implements SlotSelector {
    @Override
    public void validateSatisfied(IndexProvider[] instances) {
        SlotSelector.validateSelectorInstances(instances, 0, 1, 2, 3, 4);
    }

    @Override
    public <V> int selectSlot(V[] values, Function<V, ValueGroup> groupOf) {
        if (values.length > 1) {
            return 4;
        }
        ValueGroup singleGroup = groupOf.apply(values[0]);
        switch (singleGroup.category()) {
            case NUMBER: {
                return 1;
            }
            case TEXT: {
                return 0;
            }
            case GEOMETRY: {
                return 2;
            }
            case TEMPORAL: {
                return 3;
            }
            case UNKNOWN: {
                return -1;
            }
        }
        return 4;
    }
}

