/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.CapabilityValidator;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.NumberIndexProvider;
import org.neo4j.kernel.impl.index.schema.NumberSchemaKey;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class NumberSchemaIndexReader<VALUE extends NativeSchemaValue>
extends NativeSchemaIndexReader<NumberSchemaKey, VALUE> {
    NumberSchemaIndexReader(GBPTree<NumberSchemaKey, VALUE> tree, Layout<NumberSchemaKey, VALUE> layout, IndexSamplingConfig samplingConfig, SchemaIndexDescriptor descriptor) {
        super(tree, layout, samplingConfig, descriptor);
    }

    @Override
    void validateQuery(IndexOrder indexOrder, IndexQuery[] predicates) {
        if (predicates.length != 1) {
            throw new UnsupportedOperationException();
        }
        CapabilityValidator.validateQuery(NumberIndexProvider.CAPABILITY, indexOrder, predicates);
    }

    @Override
    boolean initializeRangeForQuery(NumberSchemaKey treeKeyFrom, NumberSchemaKey treeKeyTo, IndexQuery[] predicates) {
        IndexQuery predicate = predicates[0];
        switch (predicate.type()) {
            case exists: {
                treeKeyFrom.initAsLowest();
                treeKeyTo.initAsHighest();
                break;
            }
            case exact: {
                IndexQuery.ExactPredicate exactPredicate = (IndexQuery.ExactPredicate)predicate;
                treeKeyFrom.from(Long.MIN_VALUE, exactPredicate.value());
                treeKeyTo.from(Long.MAX_VALUE, exactPredicate.value());
                break;
            }
            case range: {
                IndexQuery.RangePredicate rangePredicate = (IndexQuery.RangePredicate)predicate;
                this.initFromForRange(rangePredicate, treeKeyFrom);
                this.initToForRange(rangePredicate, treeKeyTo);
                break;
            }
            default: {
                throw new IllegalArgumentException("IndexQuery of type " + predicate.type() + " is not supported.");
            }
        }
        return false;
    }

    private void initToForRange(IndexQuery.RangePredicate<?> rangePredicate, NumberSchemaKey treeKeyTo) {
        Value toValue = rangePredicate.toValue();
        if (toValue == Values.NO_VALUE) {
            treeKeyTo.initAsHighest();
        } else {
            treeKeyTo.from(rangePredicate.toInclusive() ? Long.MAX_VALUE : Long.MIN_VALUE, toValue);
            treeKeyTo.setCompareId(true);
        }
    }

    private void initFromForRange(IndexQuery.RangePredicate<?> rangePredicate, NumberSchemaKey treeKeyFrom) {
        Value fromValue = rangePredicate.fromValue();
        if (fromValue == Values.NO_VALUE) {
            treeKeyFrom.initAsLowest();
        } else {
            treeKeyFrom.from(rangePredicate.fromInclusive() ? Long.MIN_VALUE : Long.MAX_VALUE, fromValue);
            treeKeyFrom.setCompareId(true);
        }
    }

    @Override
    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        return true;
    }
}

