/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.neo4j.index.internal.gbptree.Header;

class NativeSchemaIndexHeaderReader
implements Header.Reader {
    byte state;
    String failureMessage;

    NativeSchemaIndexHeaderReader() {
    }

    public void read(ByteBuffer headerData) {
        this.state = headerData.get();
        if (this.state == 0) {
            this.failureMessage = NativeSchemaIndexHeaderReader.readFailureMessage(headerData);
        }
    }

    public static String readFailureMessage(ByteBuffer headerData) {
        short messageLength = headerData.getShort();
        byte[] failureMessageBytes = new byte[messageLength];
        headerData.get(failureMessageBytes);
        return new String(failureMessageBytes, StandardCharsets.UTF_8);
    }
}

