/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.ArrayList;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.BaseNodeConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;

public class NodePropertyUniqueConstraintCreator
extends BaseNodeConstraintCreator {
    protected final ArrayList<String> propertyKeys = new ArrayList();

    NodePropertyUniqueConstraintCreator(InternalSchemaActions internalCreator, Label label, String propertyKey) {
        super(internalCreator, label);
        this.propertyKeys.add(propertyKey);
    }

    @Override
    public final NodePropertyUniqueConstraintCreator assertPropertyIsUnique(String propertyKey) {
        throw new UnsupportedOperationException("You can only create one unique constraint at a time.");
    }

    @Override
    public final ConstraintDefinition create() {
        this.assertInUnterminatedTransaction();
        IndexDefinitionImpl definition = new IndexDefinitionImpl(this.actions, this.label, this.propertyKeys.toArray(new String[this.propertyKeys.size()]), true);
        return this.actions.createPropertyUniquenessConstraint(definition);
    }
}

