/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.File;
import java.io.IOException;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public abstract class IndexProvider
extends LifecycleAdapter
implements Comparable<IndexProvider> {
    public static final IndexProvider EMPTY = new IndexProvider(new Descriptor("no-index-provider", "1.0"), -1, IndexDirectoryStructure.NONE){
        private final IndexAccessor singleWriter = IndexAccessor.EMPTY;
        private final IndexPopulator singlePopulator = IndexPopulator.EMPTY;

        @Override
        public IndexAccessor getOnlineAccessor(long indexId, SchemaIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
            return this.singleWriter;
        }

        @Override
        public IndexPopulator getPopulator(long indexId, SchemaIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
            return this.singlePopulator;
        }

        @Override
        public InternalIndexState getInitialState(long indexId, SchemaIndexDescriptor descriptor) {
            return InternalIndexState.ONLINE;
        }

        @Override
        public IndexCapability getCapability(SchemaIndexDescriptor schemaIndexDescriptor) {
            return IndexCapability.NO_CAPABILITY;
        }

        @Override
        public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
            return StoreMigrationParticipant.NOT_PARTICIPATING;
        }

        @Override
        public String getPopulationFailure(long indexId, SchemaIndexDescriptor descriptor) throws IllegalStateException {
            throw new IllegalStateException();
        }
    };
    public static final Descriptor UNDECIDED = new Descriptor("Undecided", "0");
    protected final int priority;
    private final Descriptor providerDescriptor;
    private final IndexDirectoryStructure.Factory directoryStructureFactory;
    private final IndexDirectoryStructure directoryStructure;

    protected IndexProvider(IndexProvider copySource) {
        this(copySource.providerDescriptor, copySource.priority, copySource.directoryStructureFactory);
    }

    protected IndexProvider(Descriptor descriptor, int priority, IndexDirectoryStructure.Factory directoryStructureFactory) {
        this.directoryStructureFactory = directoryStructureFactory;
        assert (descriptor != null);
        this.priority = priority;
        this.providerDescriptor = descriptor;
        this.directoryStructure = directoryStructureFactory.forProvider(descriptor);
    }

    public abstract IndexPopulator getPopulator(long var1, SchemaIndexDescriptor var3, IndexSamplingConfig var4);

    public abstract IndexAccessor getOnlineAccessor(long var1, SchemaIndexDescriptor var3, IndexSamplingConfig var4) throws IOException;

    public abstract String getPopulationFailure(long var1, SchemaIndexDescriptor var3) throws IllegalStateException;

    public abstract InternalIndexState getInitialState(long var1, SchemaIndexDescriptor var3);

    public abstract IndexCapability getCapability(SchemaIndexDescriptor var1);

    public Descriptor getProviderDescriptor() {
        return this.providerDescriptor;
    }

    @Override
    public int compareTo(IndexProvider o) {
        return this.priority - o.priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexProvider other = (IndexProvider)o;
        return this.priority == other.priority && this.providerDescriptor.equals(other.providerDescriptor);
    }

    public int hashCode() {
        int result = this.priority;
        result = 31 * result + this.providerDescriptor.hashCode();
        return result;
    }

    public IndexDirectoryStructure directoryStructure() {
        return this.directoryStructure;
    }

    public abstract StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction var1, PageCache var2);

    public static class Descriptor {
        private final String key;
        private final String version;

        public Descriptor(String key, String version) {
            if (key == null) {
                throw new IllegalArgumentException("null provider key prohibited");
            }
            if (key.length() == 0) {
                throw new IllegalArgumentException("empty provider key prohibited");
            }
            if (version == null) {
                throw new IllegalArgumentException("null provider version prohibited");
            }
            this.key = key;
            this.version = version;
        }

        public String getKey() {
            return this.key;
        }

        public String getVersion() {
            return this.version;
        }

        public String name() {
            return this.key + "-" + this.version;
        }

        public int hashCode() {
            return 23 + this.key.hashCode() ^ this.version.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Descriptor) {
                Descriptor otherDescriptor = (Descriptor)obj;
                return this.key.equals(otherDescriptor.getKey()) && this.version.equals(otherDescriptor.getVersion());
            }
            return false;
        }

        public String toString() {
            return "{key=" + this.key + ", version=" + this.version + "}";
        }
    }

    public static interface Monitor {
        public static final Monitor EMPTY = new Adaptor();

        public void failedToOpenIndex(long var1, SchemaIndexDescriptor var3, String var4, Exception var5);

        public void recoveryCleanupRegistered(File var1, SchemaIndexDescriptor var2);

        public void recoveryCleanupStarted(File var1, SchemaIndexDescriptor var2);

        public void recoveryCleanupFinished(File var1, SchemaIndexDescriptor var2, long var3, long var5, long var7);

        public void recoveryCleanupClosed(File var1, SchemaIndexDescriptor var2);

        public void recoveryCleanupFailed(File var1, SchemaIndexDescriptor var2, Throwable var3);

        public static class Adaptor
        implements Monitor {
            @Override
            public void failedToOpenIndex(long indexId, SchemaIndexDescriptor schemaIndexDescriptor, String action, Exception cause) {
            }

            @Override
            public void recoveryCleanupRegistered(File indexFile, SchemaIndexDescriptor schemaIndexDescriptor) {
            }

            @Override
            public void recoveryCleanupStarted(File indexFile, SchemaIndexDescriptor schemaIndexDescriptor) {
            }

            @Override
            public void recoveryCleanupFinished(File indexFile, SchemaIndexDescriptor schemaIndexDescriptor, long numberOfPagesVisited, long numberOfCleanedCrashPointers, long durationMillis) {
            }

            @Override
            public void recoveryCleanupClosed(File indexFile, SchemaIndexDescriptor schemaIndexDescriptor) {
            }

            @Override
            public void recoveryCleanupFailed(File indexFile, SchemaIndexDescriptor schemaIndexDescriptor, Throwable throwable) {
            }
        }
    }
}

