/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import java.util.function.ToIntFunction;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.CachingInputIterable;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputCache;
import org.neo4j.values.storable.Value;

public class CachedInput
implements Input {
    private final Input actual;
    private final InputIterable nodes;
    private final InputIterable relationships;

    private CachedInput(Input actual, InputCache cache) {
        this.actual = actual;
        this.nodes = new CachingInputIterable(actual.nodes(), cache);
        this.relationships = new CachingInputIterable(actual.relationships(), cache);
    }

    @Override
    public InputIterable nodes() {
        return this.nodes;
    }

    @Override
    public InputIterable relationships() {
        return this.relationships;
    }

    @Override
    public IdMapper idMapper(NumberArrayFactory numberArrayFactory) {
        return this.actual.idMapper(numberArrayFactory);
    }

    @Override
    public Collector badCollector() {
        return this.actual.badCollector();
    }

    public static Input cacheAsNecessary(Input input, InputCache cache) {
        return new CachedInput(input, cache);
    }

    @Override
    public Input.Estimates calculateEstimates(ToIntFunction<Value[]> valueSizeCalculator) throws IOException {
        return this.actual.calculateEstimates(valueSizeCalculator);
    }
}

