/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.lang.reflect.Array;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.graphdb.traversal.Paths;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.ReverseArrayIterator;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;

public abstract class BaseToObjectValueWriter<E extends Exception>
implements AnyValueWriter<E> {
    private final Deque<Writer> stack = new ArrayDeque<Writer>();

    public BaseToObjectValueWriter() {
        this.stack.push(new ObjectWriter());
    }

    protected abstract Node newNodeProxyById(long var1);

    protected abstract Relationship newRelationshipProxyById(long var1);

    protected abstract Point newPoint(CoordinateReferenceSystem var1, double[] var2);

    public Object value() {
        assert (this.stack.size() == 1);
        return this.stack.getLast().value();
    }

    private void writeValue(Object value) {
        assert (!this.stack.isEmpty());
        Writer head = this.stack.peek();
        head.write(value);
    }

    public void writeNodeReference(long nodeId) throws RuntimeException {
        throw new UnsupportedOperationException("Cannot write a raw node reference");
    }

    public void writeNode(long nodeId, TextArray ignore, MapValue properties) throws RuntimeException {
        if (nodeId >= 0L) {
            this.writeValue(this.newNodeProxyById(nodeId));
        }
    }

    public void writeVirtualNodeHack(Object node) {
        this.writeValue(node);
    }

    public void writeRelationshipReference(long relId) throws RuntimeException {
        throw new UnsupportedOperationException("Cannot write a raw edge reference");
    }

    public void writeRelationship(long relId, long startNodeId, long endNodeId, TextValue type, MapValue properties) throws RuntimeException {
        if (relId >= 0L) {
            this.writeValue(this.newRelationshipProxyById(relId));
        }
    }

    public void writeVirtualRelationshipHack(Object relationship) {
        this.writeValue(relationship);
    }

    public void beginMap(int size) throws RuntimeException {
        this.stack.push(new MapWriter(size));
    }

    public void endMap() throws RuntimeException {
        assert (!this.stack.isEmpty());
        this.writeValue(this.stack.pop().value());
    }

    public void beginList(int size) throws RuntimeException {
        this.stack.push(new ListWriter(size));
    }

    public void endList() throws RuntimeException {
        assert (!this.stack.isEmpty());
        this.writeValue(this.stack.pop().value());
    }

    public void writePath(NodeValue[] nodes, RelationshipValue[] relationships) throws RuntimeException {
        assert (nodes != null);
        assert (nodes.length > 0);
        assert (relationships != null);
        assert (nodes.length == relationships.length + 1);
        final Node[] nodeProxies = new Node[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            nodeProxies[i] = this.newNodeProxyById(nodes[i].id());
        }
        final Relationship[] relationship = new Relationship[relationships.length];
        for (int i = 0; i < relationships.length; ++i) {
            relationship[i] = this.newRelationshipProxyById(relationships[i].id());
        }
        this.writeValue(new Path(){

            public Node startNode() {
                return nodeProxies[0];
            }

            public Node endNode() {
                return nodeProxies[nodeProxies.length - 1];
            }

            public Relationship lastRelationship() {
                return relationship[relationship.length - 1];
            }

            public Iterable<Relationship> relationships() {
                return Arrays.asList(relationship);
            }

            public Iterable<Relationship> reverseRelationships() {
                return () -> new ReverseArrayIterator((Object[])relationship);
            }

            public Iterable<Node> nodes() {
                return Arrays.asList(nodeProxies);
            }

            public Iterable<Node> reverseNodes() {
                return () -> new ReverseArrayIterator((Object[])nodeProxies);
            }

            public int length() {
                return relationship.length;
            }

            public int hashCode() {
                if (relationship.length == 0) {
                    return this.startNode().hashCode();
                }
                return Arrays.hashCode(relationship);
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj instanceof Path) {
                    Path other = (Path)obj;
                    return this.startNode().equals(other.startNode()) && Iterators.iteratorsEqual(this.relationships().iterator(), other.relationships().iterator());
                }
                return false;
            }

            public Iterator<PropertyContainer> iterator() {
                return new Iterator<PropertyContainer>(){
                    Iterator<? extends PropertyContainer> current;
                    Iterator<? extends PropertyContainer> next;
                    {
                        this.current = this.nodes().iterator();
                        this.next = this.relationships().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.current.hasNext();
                    }

                    @Override
                    public PropertyContainer next() {
                        try {
                            PropertyContainer propertyContainer = this.current.next();
                            return propertyContainer;
                        }
                        finally {
                            Iterator<? extends PropertyContainer> temp = this.current;
                            this.current = this.next;
                            this.next = temp;
                        }
                    }

                    @Override
                    public void remove() {
                        this.next.remove();
                    }
                };
            }

            public String toString() {
                try {
                    return Paths.defaultPathToString((Path)this);
                }
                catch (DatabaseShutdownException | NotInTransactionException throwable) {
                    StringBuilder sb = new StringBuilder();
                    for (Relationship rel : this.relationships()) {
                        if (sb.length() == 0) {
                            sb.append("(?)");
                        }
                        sb.append("-[?,").append(rel.getId()).append("]-(?)");
                    }
                    return sb.toString();
                }
            }
        });
    }

    public final void writePoint(CoordinateReferenceSystem crs, double[] coordinate) {
        this.writeValue(this.newPoint(crs, coordinate));
    }

    public void writeNull() throws RuntimeException {
        this.writeValue(null);
    }

    public void writeBoolean(boolean value) throws RuntimeException {
        this.writeValue(value);
    }

    public void writeInteger(byte value) throws RuntimeException {
        this.writeValue(value);
    }

    public void writeInteger(short value) throws RuntimeException {
        this.writeValue(value);
    }

    public void writeInteger(int value) throws RuntimeException {
        this.writeValue(value);
    }

    public void writeInteger(long value) throws RuntimeException {
        this.writeValue(value);
    }

    public void writeFloatingPoint(float value) throws RuntimeException {
        this.writeValue(Float.valueOf(value));
    }

    public void writeFloatingPoint(double value) throws RuntimeException {
        this.writeValue(value);
    }

    public void writeString(String value) throws RuntimeException {
        this.writeValue(value);
    }

    public void writeString(char value) throws RuntimeException {
        this.writeValue(Character.valueOf(value));
    }

    public void beginArray(int size, ValueWriter.ArrayType arrayType) throws RuntimeException {
        this.stack.push(new ArrayWriter(size, arrayType));
    }

    public void endArray() throws RuntimeException {
        assert (!this.stack.isEmpty());
        this.writeValue(this.stack.pop().value());
    }

    public void writeByteArray(byte[] value) throws RuntimeException {
        this.writeValue(value);
    }

    public void writeDuration(long months, long days, long seconds, int nanos) {
        this.writeValue(DurationValue.duration((long)months, (long)days, (long)seconds, (long)nanos));
    }

    public void writeDate(LocalDate localDate) throws RuntimeException {
        this.writeValue(localDate);
    }

    public void writeLocalTime(LocalTime localTime) throws RuntimeException {
        this.writeValue(localTime);
    }

    public void writeTime(OffsetTime offsetTime) throws RuntimeException {
        this.writeValue(offsetTime);
    }

    public void writeLocalDateTime(LocalDateTime localDateTime) throws RuntimeException {
        this.writeValue(localDateTime);
    }

    public void writeDateTime(ZonedDateTime zonedDateTime) throws RuntimeException {
        this.writeValue(zonedDateTime);
    }

    private static class ListWriter
    implements Writer {
        private final List<Object> list;

        ListWriter(int size) {
            this.list = new ArrayList<Object>(size);
        }

        @Override
        public void write(Object value) {
            this.list.add(value);
        }

        @Override
        public Object value() {
            return this.list;
        }
    }

    private static class ArrayWriter
    implements Writer {
        protected final Object array;
        private int index;

        ArrayWriter(int size, ValueWriter.ArrayType arrayType) {
            switch (arrayType) {
                case SHORT: {
                    this.array = Array.newInstance(Short.TYPE, size);
                    break;
                }
                case INT: {
                    this.array = Array.newInstance(Integer.TYPE, size);
                    break;
                }
                case BYTE: {
                    this.array = Array.newInstance(Byte.TYPE, size);
                    break;
                }
                case LONG: {
                    this.array = Array.newInstance(Long.TYPE, size);
                    break;
                }
                case FLOAT: {
                    this.array = Array.newInstance(Float.TYPE, size);
                    break;
                }
                case DOUBLE: {
                    this.array = Array.newInstance(Double.TYPE, size);
                    break;
                }
                case BOOLEAN: {
                    this.array = Array.newInstance(Boolean.TYPE, size);
                    break;
                }
                case STRING: {
                    this.array = Array.newInstance(String.class, size);
                    break;
                }
                case CHAR: {
                    this.array = Array.newInstance(Character.TYPE, size);
                    break;
                }
                default: {
                    this.array = new Object[size];
                }
            }
        }

        @Override
        public void write(Object value) {
            Array.set(this.array, this.index++, value);
        }

        @Override
        public Object value() {
            return this.array;
        }
    }

    private static class MapWriter
    implements Writer {
        private String key;
        private boolean isKey = true;
        private final HashMap<String, Object> map;

        MapWriter(int size) {
            this.map = new HashMap(size);
        }

        @Override
        public void write(Object value) {
            if (this.isKey) {
                this.key = (String)value;
                this.isKey = false;
            } else {
                this.map.put(this.key, value);
                this.isKey = true;
            }
        }

        @Override
        public Object value() {
            return this.map;
        }
    }

    private static class ObjectWriter
    implements Writer {
        private Object value;

        private ObjectWriter() {
        }

        @Override
        public void write(Object value) {
            this.value = value;
        }

        @Override
        public Object value() {
            return this.value;
        }
    }

    private static interface Writer {
        public void write(Object var1);

        public Object value();
    }
}

