/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;

public class DefaultIndexProviderMap
implements IndexProviderMap {
    private final IndexProvider defaultIndexProvider;
    private final Map<IndexProvider.Descriptor, IndexProvider> indexProviders = new HashMap<IndexProvider.Descriptor, IndexProvider>();

    public DefaultIndexProviderMap(IndexProvider defaultIndexProvider) {
        this(defaultIndexProvider, Collections.emptyList());
    }

    public DefaultIndexProviderMap(IndexProvider defaultIndexProvider, Iterable<IndexProvider> additionalIndexProviders) {
        this.defaultIndexProvider = defaultIndexProvider;
        this.indexProviders.put(defaultIndexProvider.getProviderDescriptor(), defaultIndexProvider);
        for (IndexProvider provider : additionalIndexProviders) {
            IndexProvider.Descriptor providerDescriptor = provider.getProviderDescriptor();
            Objects.requireNonNull(providerDescriptor);
            IndexProvider existing = this.indexProviders.putIfAbsent(providerDescriptor, provider);
            if (existing == null) continue;
            throw new IllegalArgumentException("Tried to load multiple schema index providers with the same provider descriptor " + providerDescriptor + ". First loaded " + existing + " then " + provider);
        }
    }

    @Override
    public IndexProvider getDefaultProvider() {
        return this.defaultIndexProvider;
    }

    @Override
    public IndexProvider apply(IndexProvider.Descriptor descriptor) {
        IndexProvider provider = this.indexProviders.get(descriptor);
        if (provider != null) {
            return provider;
        }
        throw new IllegalArgumentException("Tried to get index provider for an existing index with provider " + descriptor + " whereas available providers in this session being " + this.indexProviders + ", and default being " + this.defaultIndexProvider);
    }

    @Override
    public void accept(Consumer<IndexProvider> visitor) {
        this.indexProviders.values().forEach(visitor);
    }
}

