/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaUtil;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.store.record.SchemaRuleSerialization;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class IndexRule
extends SchemaRule
implements SchemaIndexDescriptor.Supplier {
    private final IndexProvider.Descriptor providerDescriptor;
    private final SchemaIndexDescriptor descriptor;
    private final Long owningConstraint;

    public static IndexRule indexRule(long id, SchemaIndexDescriptor descriptor, IndexProvider.Descriptor providerDescriptor) {
        return new IndexRule(id, providerDescriptor, descriptor, null);
    }

    public static IndexRule constraintIndexRule(long id, SchemaIndexDescriptor descriptor, IndexProvider.Descriptor providerDescriptor, Long owningConstraint) {
        return new IndexRule(id, providerDescriptor, descriptor, owningConstraint);
    }

    public static IndexRule indexRule(long id, SchemaIndexDescriptor descriptor, IndexProvider.Descriptor providerDescriptor, String name) {
        return new IndexRule(id, providerDescriptor, descriptor, null, name);
    }

    public static IndexRule constraintIndexRule(long id, SchemaIndexDescriptor descriptor, IndexProvider.Descriptor providerDescriptor, Long owningConstraint, String name) {
        return new IndexRule(id, providerDescriptor, descriptor, owningConstraint, name);
    }

    IndexRule(long id, IndexProvider.Descriptor providerDescriptor, SchemaIndexDescriptor descriptor, Long owningConstraint) {
        this(id, providerDescriptor, descriptor, owningConstraint, null);
    }

    IndexRule(long id, IndexProvider.Descriptor providerDescriptor, SchemaIndexDescriptor descriptor, Long owningConstraint, String name) {
        super(id, name);
        if (providerDescriptor == null) {
            throw new IllegalArgumentException("null provider descriptor prohibited");
        }
        this.descriptor = descriptor;
        this.owningConstraint = owningConstraint;
        this.providerDescriptor = providerDescriptor;
    }

    public IndexProvider.Descriptor getProviderDescriptor() {
        return this.providerDescriptor;
    }

    public boolean canSupportUniqueConstraint() {
        return this.descriptor.type() == SchemaIndexDescriptor.Type.UNIQUE;
    }

    public Long getOwningConstraint() {
        if (!this.canSupportUniqueConstraint()) {
            throw new IllegalStateException("Can only get owner from constraint indexes.");
        }
        return this.owningConstraint;
    }

    public IndexRule withOwningConstraint(long constraintId) {
        if (!this.canSupportUniqueConstraint()) {
            throw new IllegalStateException(this + " is not a constraint index");
        }
        return IndexRule.constraintIndexRule(this.id, this.descriptor, this.providerDescriptor, constraintId);
    }

    @Override
    public byte[] serialize() {
        return SchemaRuleSerialization.serialize(this);
    }

    public String toString() {
        String ownerString = "";
        if (this.canSupportUniqueConstraint()) {
            ownerString = ", owner=" + this.owningConstraint;
        }
        return "IndexRule[id=" + this.id + ", descriptor=" + this.descriptor.userDescription(SchemaUtil.idTokenNameLookup) + ", provider=" + this.providerDescriptor + ownerString + "]";
    }

    public SchemaDescriptor schema() {
        return this.descriptor.schema();
    }

    @Override
    public SchemaIndexDescriptor getIndexDescriptor() {
        return this.descriptor;
    }

    public boolean equals(Object o) {
        if (o instanceof IndexRule) {
            IndexRule that = (IndexRule)o;
            return this.descriptor.equals(that.descriptor);
        }
        return false;
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }
}

