/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.scheduler;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.scheduler.GroupedDaemonThreadFactory;
import org.neo4j.kernel.impl.scheduler.ThreadPoolManager;
import org.neo4j.kernel.impl.scheduler.TimeBasedTaskScheduler;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.time.Clocks;

public class CentralJobScheduler
extends LifecycleAdapter
implements JobScheduler {
    private static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger();
    private static final JobScheduler.Group SCHEDULER_GROUP = new JobScheduler.Group("Scheduler");
    private final TimeBasedTaskScheduler scheduler;
    private final Thread schedulerThread;
    private final ConcurrentHashMap<JobScheduler.Group, ExecutorService> workStealingExecutors = new ConcurrentHashMap(1);
    private final ThreadGroup topLevelGroup = new ThreadGroup("Neo4j-" + INSTANCE_COUNTER.incrementAndGet());
    private final ThreadPoolManager pools = new ThreadPoolManager(this.topLevelGroup);
    private volatile boolean started;

    public CentralJobScheduler() {
        GroupedDaemonThreadFactory threadFactory = new GroupedDaemonThreadFactory(SCHEDULER_GROUP, this.topLevelGroup);
        this.scheduler = new TimeBasedTaskScheduler(Clocks.nanoClock(), this.pools);
        this.schedulerThread = threadFactory.newThread(this.scheduler);
        int priority = 6;
        this.schedulerThread.setPriority(priority);
    }

    public void init() {
        this.schedulerThread.start();
        this.started = true;
    }

    public Executor executor(JobScheduler.Group group) {
        return job -> this.schedule(group, job);
    }

    public ExecutorService workStealingExecutor(JobScheduler.Group group, int parallelism) {
        return this.workStealingExecutors.computeIfAbsent(group, g -> this.createNewWorkStealingExecutor((JobScheduler.Group)g, parallelism));
    }

    public ThreadFactory threadFactory(JobScheduler.Group group) {
        return this.pools.getThreadPool(group).getThreadFactory();
    }

    private ExecutorService createNewWorkStealingExecutor(JobScheduler.Group group, int parallelism) {
        GroupedDaemonThreadFactory factory = new GroupedDaemonThreadFactory(group, this.topLevelGroup);
        return new ForkJoinPool(parallelism, factory, null, false);
    }

    public JobScheduler.JobHandle schedule(JobScheduler.Group group, Runnable job) {
        if (!this.started) {
            throw new RejectedExecutionException("Scheduler is not started");
        }
        return this.pools.submit(group, job);
    }

    public JobScheduler.JobHandle scheduleRecurring(JobScheduler.Group group, Runnable runnable, long period, TimeUnit timeUnit) {
        return this.scheduleRecurring(group, runnable, 0L, period, timeUnit);
    }

    public JobScheduler.JobHandle scheduleRecurring(JobScheduler.Group group, Runnable runnable, long initialDelay, long period, TimeUnit unit) {
        return this.scheduler.submit(group, runnable, unit.toNanos(initialDelay), unit.toNanos(period));
    }

    public JobScheduler.JobHandle schedule(JobScheduler.Group group, Runnable runnable, long initialDelay, TimeUnit unit) {
        return this.scheduler.submit(group, runnable, unit.toNanos(initialDelay), 0L);
    }

    public void shutdown() {
        this.started = false;
        InterruptedException exception = this.shutDownScheduler();
        exception = (InterruptedException)Exceptions.chain((Throwable)exception, (Throwable)this.pools.shutDownAll());
        for (ExecutorService workStealingExecutor : this.workStealingExecutors.values()) {
            exception = this.shutdownPool(workStealingExecutor, exception);
        }
        this.workStealingExecutors.clear();
        if (exception != null) {
            throw new RuntimeException("Unable to shut down job scheduler properly.", exception);
        }
    }

    private InterruptedException shutDownScheduler() {
        this.scheduler.stop();
        try {
            this.schedulerThread.join();
        }
        catch (InterruptedException e) {
            return e;
        }
        return null;
    }

    private InterruptedException shutdownPool(ExecutorService pool, InterruptedException exception) {
        if (pool != null) {
            pool.shutdown();
            try {
                pool.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                return (InterruptedException)Exceptions.chain((Throwable)exception, (Throwable)e);
            }
        }
        return exception;
    }
}

