/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class FusionSelector00
implements FusionIndexProvider.Selector {
    @Override
    public void validateSatisfied(Object[] instances) {
        FusionIndexBase.validateSelectorInstances(instances, 4, 2, 3);
    }

    @Override
    public int selectSlot(Value ... values) {
        if (values.length > 1) {
            return 4;
        }
        Value singleValue = values[0];
        if (Values.isGeometryValue((Value)singleValue)) {
            return 2;
        }
        if (Values.isTemporalValue((Value)singleValue)) {
            return 3;
        }
        return 4;
    }

    @Override
    public IndexReader select(IndexReader[] instances, IndexQuery ... predicates) {
        if (predicates.length > 1) {
            return instances[4];
        }
        IndexQuery predicate = predicates[0];
        if (predicate instanceof IndexQuery.ExactPredicate) {
            IndexQuery.ExactPredicate exactPredicate = (IndexQuery.ExactPredicate)predicate;
            return this.select(instances, exactPredicate.value());
        }
        if (predicate instanceof IndexQuery.RangePredicate) {
            switch (predicate.valueGroup()) {
                case GEOMETRY: {
                    return instances[2];
                }
                case DATE: 
                case LOCAL_DATE_TIME: 
                case ZONED_DATE_TIME: 
                case LOCAL_TIME: 
                case ZONED_TIME: 
                case DURATION: {
                    return instances[3];
                }
            }
        }
        if (predicate instanceof IndexQuery.ExistsPredicate) {
            return null;
        }
        return instances[4];
    }
}

