/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import java.util.Arrays;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexAccessor;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexPopulator;
import org.neo4j.kernel.impl.newapi.UnionIndexCapability;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public class FusionIndexProvider
extends IndexProvider {
    private final IndexProvider[] providers = new IndexProvider[5];
    private final Selector selector;
    private final DropAction dropAction;

    public FusionIndexProvider(IndexProvider stringProvider, IndexProvider numberProvider, IndexProvider spatialProvider, IndexProvider temporalProvider, IndexProvider luceneProvider, Selector selector, IndexProvider.Descriptor descriptor, int priority, IndexDirectoryStructure.Factory directoryStructure, FileSystemAbstraction fs) {
        super(descriptor, priority, directoryStructure);
        this.fillProvidersArray(stringProvider, numberProvider, spatialProvider, temporalProvider, luceneProvider);
        selector.validateSatisfied(this.providers);
        this.selector = selector;
        this.dropAction = new FileSystemDropAction(fs, this.directoryStructure());
    }

    private void fillProvidersArray(IndexProvider stringProvider, IndexProvider numberProvider, IndexProvider spatialProvider, IndexProvider temporalProvider, IndexProvider luceneProvider) {
        this.providers[0] = stringProvider;
        this.providers[1] = numberProvider;
        this.providers[2] = spatialProvider;
        this.providers[3] = temporalProvider;
        this.providers[4] = luceneProvider;
    }

    @Override
    public IndexPopulator getPopulator(long indexId, SchemaIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        return new FusionIndexPopulator(FusionIndexBase.instancesAs(this.providers, IndexPopulator.class, provider -> provider.getPopulator(indexId, descriptor, samplingConfig)), this.selector, indexId, this.dropAction);
    }

    @Override
    public IndexAccessor getOnlineAccessor(long indexId, SchemaIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        return new FusionIndexAccessor(FusionIndexBase.instancesAs(this.providers, IndexAccessor.class, provider -> provider.getOnlineAccessor(indexId, descriptor, samplingConfig)), this.selector, indexId, descriptor, this.dropAction);
    }

    @Override
    public String getPopulationFailure(long indexId, SchemaIndexDescriptor descriptor) throws IllegalStateException {
        StringBuilder builder = new StringBuilder();
        FusionIndexBase.forAll(p -> this.writeFailure(p.getClass().getSimpleName(), builder, (IndexProvider)p, indexId, descriptor), this.providers);
        String failure = builder.toString();
        if (!failure.isEmpty()) {
            return failure;
        }
        throw new IllegalStateException("None of the indexes were in a failed state");
    }

    private void writeFailure(String indexName, StringBuilder builder, IndexProvider provider, long indexId, SchemaIndexDescriptor descriptor) {
        try {
            String failure = provider.getPopulationFailure(indexId, descriptor);
            builder.append(indexName);
            builder.append(": ");
            builder.append(failure);
            builder.append(' ');
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public InternalIndexState getInitialState(long indexId, SchemaIndexDescriptor descriptor) {
        InternalIndexState[] states = FusionIndexBase.instancesAs(this.providers, InternalIndexState.class, p -> p.getInitialState(indexId, descriptor));
        if (Arrays.stream(states).anyMatch(state -> state == InternalIndexState.FAILED)) {
            return InternalIndexState.FAILED;
        }
        if (Arrays.stream(states).anyMatch(state -> state == InternalIndexState.POPULATING)) {
            return InternalIndexState.POPULATING;
        }
        return InternalIndexState.ONLINE;
    }

    @Override
    public IndexCapability getCapability(SchemaIndexDescriptor schemaIndexDescriptor) {
        IndexCapability[] capabilities = new IndexCapability[this.providers.length];
        for (int i = 0; i < this.providers.length; ++i) {
            capabilities[i] = this.providers[i].getCapability(schemaIndexDescriptor);
        }
        return new UnionIndexCapability(capabilities){

            @Override
            public IndexOrder[] orderCapability(ValueGroup ... valueGroups) {
                if (valueGroups.length == 1 && valueGroups[0] == ValueGroup.UNKNOWN) {
                    return new IndexOrder[0];
                }
                return super.orderCapability(valueGroups);
            }
        };
    }

    @Override
    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
        return StoreMigrationParticipant.NOT_PARTICIPATING;
    }

    private static class FileSystemDropAction
    implements DropAction {
        private final FileSystemAbstraction fs;
        private final IndexDirectoryStructure directoryStructure;

        FileSystemDropAction(FileSystemAbstraction fs, IndexDirectoryStructure directoryStructure) {
            this.fs = fs;
            this.directoryStructure = directoryStructure;
        }

        @Override
        public void drop(long indexId) throws IOException {
            this.fs.deleteRecursively(this.directoryStructure.directoryForIndex(indexId));
        }
    }

    @FunctionalInterface
    static interface DropAction {
        public void drop(long var1) throws IOException;
    }

    static interface Selector {
        public void validateSatisfied(Object[] var1);

        public int selectSlot(Value ... var1);

        default public <T> T select(T[] instances, Value ... values) {
            return instances[this.selectSlot(values)];
        }

        public IndexReader select(IndexReader[] var1, IndexQuery ... var2);
    }
}

