/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.ZoneId;
import java.time.ZoneOffset;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.TimeZones;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class ZonedDateTimeSchemaKey
extends NativeSchemaKey<ZonedDateTimeSchemaKey> {
    static final int SIZE = 24;
    long epochSecondUTC;
    int nanoOfSecond;
    short zoneId;
    int zoneOffsetMinutes;

    ZonedDateTimeSchemaKey() {
    }

    @Override
    public Value asValue() {
        return TimeZones.validZoneId((short)this.zoneId) ? DateTimeValue.datetime((long)this.epochSecondUTC, (long)this.nanoOfSecond, (ZoneId)ZoneId.of(TimeZones.map((short)this.zoneId))) : DateTimeValue.datetime((long)this.epochSecondUTC, (long)this.nanoOfSecond, (ZoneOffset)ZoneOffset.ofTotalSeconds(this.zoneOffsetMinutes * 60));
    }

    @Override
    public void initValueAsLowest() {
        this.epochSecondUTC = Long.MIN_VALUE;
        this.nanoOfSecond = Integer.MIN_VALUE;
        this.zoneId = Short.MIN_VALUE;
        this.zoneOffsetMinutes = Integer.MIN_VALUE;
    }

    @Override
    public void initValueAsHighest() {
        this.epochSecondUTC = Long.MAX_VALUE;
        this.nanoOfSecond = Integer.MAX_VALUE;
        this.zoneId = Short.MAX_VALUE;
        this.zoneOffsetMinutes = Integer.MAX_VALUE;
    }

    @Override
    public int compareValueTo(ZonedDateTimeSchemaKey other) {
        int compare = Long.compare(this.epochSecondUTC, other.epochSecondUTC);
        if (compare == 0 && (compare = Integer.compare(this.nanoOfSecond, other.nanoOfSecond)) == 0 && this.hasValidTimeZone() && other.hasValidTimeZone()) {
            compare = Values.COMPARATOR.compare(this.asValue(), other.asValue());
        }
        return compare;
    }

    public String toString() {
        return String.format("value=%s,entityId=%d,epochSecond=%d,nanoOfSecond=%d,zoneId=%d,zoneOffset=%d", this.asValue(), this.getEntityId(), this.epochSecondUTC, this.nanoOfSecond, this.zoneId, this.zoneOffsetMinutes * 60);
    }

    @Override
    public void writeDateTime(long epochSecondUTC, int nano, int offsetSeconds) {
        this.epochSecondUTC = epochSecondUTC;
        this.nanoOfSecond = nano;
        this.zoneOffsetMinutes = offsetSeconds / 60;
        this.zoneId = (short)-1;
    }

    @Override
    public void writeDateTime(long epochSecondUTC, int nano, String zoneId) {
        this.epochSecondUTC = epochSecondUTC;
        this.nanoOfSecond = nano;
        this.zoneId = TimeZones.map((String)zoneId);
        this.zoneOffsetMinutes = 0;
    }

    @Override
    protected Value assertCorrectType(Value value) {
        if (!(value instanceof DateTimeValue)) {
            throw new IllegalArgumentException("Key layout does only support DateTimeValue, tried to create key from " + value);
        }
        return value;
    }

    private boolean hasValidTimeZone() {
        return TimeZones.validZoneId((short)this.zoneId) || TimeZones.validZoneOffset((int)(this.zoneOffsetMinutes * 60));
    }
}

