/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.neo4j.values.storable.ValueGroup;

class TemporalIndexCache<T, E extends Exception>
implements Iterable<T> {
    private final Factory<T, E> factory;
    private volatile T date;
    private volatile T localDateTime;
    private volatile T zonedDateTime;
    private volatile T localTime;
    private volatile T zonedTime;
    private volatile T duration;
    private List<T> parts;

    TemporalIndexCache(Factory<T, E> factory) {
        this.factory = factory;
        this.parts = new ArrayList<T>();
    }

    T uncheckedSelect(ValueGroup valueGroup) {
        try {
            return this.select(valueGroup);
        }
        catch (Exception t) {
            throw new RuntimeException(t);
        }
    }

    T select(ValueGroup valueGroup) throws E {
        switch (valueGroup) {
            case DATE: {
                return this.date();
            }
            case LOCAL_DATE_TIME: {
                return this.localDateTime();
            }
            case ZONED_DATE_TIME: {
                return this.zonedDateTime();
            }
            case LOCAL_TIME: {
                return this.localTime();
            }
            case ZONED_TIME: {
                return this.zonedTime();
            }
            case DURATION: {
                return this.duration();
            }
        }
        throw new IllegalStateException("Unsupported value group " + valueGroup);
    }

    <RESULT> RESULT selectOrElse(ValueGroup valueGroup, Function<T, RESULT> function, RESULT orElse) {
        switch (valueGroup) {
            case DATE: {
                return this.date != null ? function.apply(this.date) : orElse;
            }
            case LOCAL_DATE_TIME: {
                return this.localDateTime != null ? function.apply(this.localDateTime) : orElse;
            }
            case ZONED_DATE_TIME: {
                return this.zonedDateTime != null ? function.apply(this.zonedDateTime) : orElse;
            }
            case LOCAL_TIME: {
                return this.localTime != null ? function.apply(this.localTime) : orElse;
            }
            case ZONED_TIME: {
                return this.zonedTime != null ? function.apply(this.zonedTime) : orElse;
            }
            case DURATION: {
                return this.duration != null ? function.apply(this.duration) : orElse;
            }
        }
        throw new IllegalStateException("Unsupported value group " + valueGroup);
    }

    T date() throws E {
        if (this.date == null) {
            this.date = this.factory.newDate();
            this.addPartToList(this.date);
        }
        return this.date;
    }

    T localDateTime() throws E {
        if (this.localDateTime == null) {
            this.localDateTime = this.factory.newLocalDateTime();
            this.addPartToList(this.localDateTime);
        }
        return this.localDateTime;
    }

    T zonedDateTime() throws E {
        if (this.zonedDateTime == null) {
            this.zonedDateTime = this.factory.newZonedDateTime();
            this.addPartToList(this.zonedDateTime);
        }
        return this.zonedDateTime;
    }

    T localTime() throws E {
        if (this.localTime == null) {
            this.localTime = this.factory.newLocalTime();
            this.addPartToList(this.localTime);
        }
        return this.localTime;
    }

    T zonedTime() throws E {
        if (this.zonedTime == null) {
            this.zonedTime = this.factory.newZonedTime();
            this.addPartToList(this.zonedTime);
        }
        return this.zonedTime;
    }

    T duration() throws E {
        if (this.duration == null) {
            this.duration = this.factory.newDuration();
            this.addPartToList(this.duration);
        }
        return this.duration;
    }

    private void addPartToList(T t) {
        if (t != null) {
            this.parts.add(t);
        }
    }

    void loadAll() {
        try {
            this.date();
            this.zonedDateTime();
            this.localDateTime();
            this.zonedTime();
            this.localTime();
            this.duration();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.parts.iterator();
    }

    static interface Factory<T, E extends Exception> {
        public T newDate() throws E;

        public T newLocalDateTime() throws E;

        public T newZonedDateTime() throws E;

        public T newLocalTime() throws E;

        public T newZonedTime() throws E;

        public T newDuration() throws E;
    }
}

