/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.index.schema.SpatialIndexCache;
import org.neo4j.kernel.impl.index.schema.SpatialIndexPopulator;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;

public class SpatialIndexPopulatingUpdater
extends SpatialIndexCache<IndexUpdater, IOException>
implements IndexUpdater {
    SpatialIndexPopulatingUpdater(SpatialIndexPopulator populator, PropertyAccessor propertyAccessor) {
        super(new PartFactory(populator, propertyAccessor));
    }

    @Override
    public void process(IndexEntryUpdate<?> update) throws IOException, IndexEntryConflictException {
        PointValue value = (PointValue)update.values()[0];
        switch (update.updateMode()) {
            case ADDED: {
                ((IndexUpdater)this.select(value.getCoordinateReferenceSystem())).process(update);
                break;
            }
            case CHANGED: {
                PointValue fromValue = (PointValue)update.beforeValues()[0];
                IndexUpdater from = (IndexUpdater)this.select(fromValue.getCoordinateReferenceSystem());
                IndexUpdater to = (IndexUpdater)this.select(value.getCoordinateReferenceSystem());
                if (from == to) {
                    from.process(update);
                    break;
                }
                from.process(IndexEntryUpdate.remove(update.getEntityId(), update.indexKey(), update.beforeValues()));
                to.process(IndexEntryUpdate.add(update.getEntityId(), update.indexKey(), update.values()));
                break;
            }
            case REMOVED: {
                ((IndexUpdater)this.select(value.getCoordinateReferenceSystem())).process(update);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown update mode");
            }
        }
    }

    @Override
    public void close() throws IOException, IndexEntryConflictException {
        for (IndexUpdater updater : this) {
            updater.close();
        }
    }

    static class PartFactory
    implements SpatialIndexCache.Factory<IndexUpdater, IOException> {
        private final SpatialIndexPopulator populator;
        private PropertyAccessor propertyAccessor;

        PartFactory(SpatialIndexPopulator populator, PropertyAccessor propertyAccessor) {
            this.populator = populator;
            this.propertyAccessor = propertyAccessor;
        }

        @Override
        public IndexUpdater newSpatial(CoordinateReferenceSystem crs) throws IOException {
            return ((SpatialIndexPopulator.PartPopulator)this.populator.select(crs)).newPopulatingUpdater(this.propertyAccessor);
        }
    }
}

