/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Iterator;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.CapableIndexReference;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.properties.PropertyKeyIdIterator;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.DegreeVisitor;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.store.AllNodeIterator;
import org.neo4j.kernel.impl.api.store.AllRelationshipIterator;
import org.neo4j.kernel.impl.api.store.DefaultCapableIndexReference;
import org.neo4j.kernel.impl.api.store.DegreeCounter;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.core.IteratingPropertyReceiver;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeToken;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.Token;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class StorageLayer
implements StoreReadLayer {
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final LabelTokenHolder labelTokenHolder;
    private final RelationshipTypeTokenHolder relationshipTokenHolder;
    private final IndexingService indexService;
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final RecordStore<RelationshipGroupRecord> relationshipGroupStore;
    private final SchemaStorage schemaStorage;
    private final CountsTracker counts;
    private final PropertyLoader propertyLoader;
    private final Supplier<StorageStatement> statementProvider;
    private final SchemaCache schemaCache;

    public StorageLayer(PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokenHolder, RelationshipTypeTokenHolder relationshipTokenHolder, SchemaStorage schemaStorage, NeoStores neoStores, IndexingService indexService, Supplier<StorageStatement> storeStatementSupplier, SchemaCache schemaCache) {
        this.relationshipTokenHolder = relationshipTokenHolder;
        this.schemaStorage = schemaStorage;
        this.indexService = indexService;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.labelTokenHolder = labelTokenHolder;
        this.statementProvider = storeStatementSupplier;
        this.nodeStore = neoStores.getNodeStore();
        this.relationshipStore = neoStores.getRelationshipStore();
        this.relationshipGroupStore = neoStores.getRelationshipGroupStore();
        this.counts = neoStores.getCounts();
        this.propertyLoader = new PropertyLoader(neoStores);
        this.schemaCache = schemaCache;
    }

    @Override
    public StorageStatement newStatement() {
        return this.statementProvider.get();
    }

    @Override
    public int labelGetOrCreateForName(String label) throws TooManyLabelsException {
        try {
            return this.labelTokenHolder.getOrCreateId(label);
        }
        catch (TransactionFailureException e) {
            if (e.getCause() instanceof UnderlyingStorageException && e.getCause().getMessage().equals("Id capacity exceeded")) {
                throw new TooManyLabelsException((Throwable)e);
            }
            throw e;
        }
    }

    @Override
    public int labelGetForName(String label) {
        return this.labelTokenHolder.getIdByName(label);
    }

    @Override
    public String labelGetName(int labelId) throws LabelNotFoundKernelException {
        try {
            return ((Token)this.labelTokenHolder.getTokenById(labelId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new LabelNotFoundKernelException("Label by id " + labelId, (Exception)e);
        }
    }

    @Override
    public PrimitiveLongResourceIterator nodesGetForLabel(StorageStatement statement, int labelId) {
        return statement.getLabelScanReader().nodesWithLabel(labelId);
    }

    @Override
    public SchemaIndexDescriptor indexGetForSchema(SchemaDescriptor descriptor) {
        return this.schemaCache.indexDescriptor(descriptor);
    }

    @Override
    public Iterator<SchemaIndexDescriptor> indexesGetForLabel(int labelId) {
        return this.schemaCache.indexDescriptorsForLabel(labelId);
    }

    @Override
    public Iterator<SchemaIndexDescriptor> indexesGetAll() {
        return StorageLayer.toIndexDescriptors(this.schemaCache.indexRules());
    }

    @Override
    public Iterator<SchemaIndexDescriptor> indexesGetRelatedToProperty(int propertyId) {
        return this.schemaCache.indexesByProperty(propertyId);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(SchemaIndexDescriptor index) {
        IndexRule rule = this.indexRule(index);
        if (rule != null) {
            return rule.getOwningConstraint();
        }
        return null;
    }

    @Override
    public long indexGetCommittedId(SchemaIndexDescriptor index) throws SchemaRuleNotFoundException {
        IndexRule rule = this.indexRule(index);
        if (rule == null) {
            throw new SchemaRuleNotFoundException(SchemaRule.Kind.INDEX_RULE, index.schema());
        }
        return rule.getId();
    }

    @Override
    public InternalIndexState indexGetState(SchemaIndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getIndexProxy(descriptor.schema()).getState();
    }

    @Override
    public IndexProvider.Descriptor indexGetProviderDescriptor(SchemaIndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getIndexProxy(descriptor.schema()).getProviderDescriptor();
    }

    @Override
    public CapableIndexReference indexReference(SchemaIndexDescriptor descriptor) throws IndexNotFoundKernelException {
        boolean unique = descriptor.type() == SchemaIndexDescriptor.Type.UNIQUE;
        SchemaDescriptor schema = descriptor.schema();
        IndexProxy indexProxy = this.indexService.getIndexProxy(schema);
        return new DefaultCapableIndexReference(unique, indexProxy.getIndexCapability(), indexProxy.getProviderDescriptor(), schema.keyId(), schema.getPropertyIds());
    }

    @Override
    public PopulationProgress indexGetPopulationProgress(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getIndexProxy(descriptor).getIndexPopulationProgress();
    }

    @Override
    public long indexSize(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        Register.DoubleLongRegister result = this.indexService.indexUpdatesAndSize(descriptor);
        return result.readSecond();
    }

    @Override
    public double indexUniqueValuesPercentage(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.indexUniqueValuesPercentage(descriptor);
    }

    @Override
    public String indexGetFailure(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getIndexProxy(descriptor).getPopulationFailure().asString();
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetForSchema(SchemaDescriptor descriptor) {
        return this.schemaCache.constraintsForSchema(descriptor);
    }

    @Override
    public boolean constraintExists(ConstraintDescriptor descriptor) {
        return this.schemaCache.hasConstraintRule(descriptor);
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int labelId) {
        return this.schemaCache.constraintsForLabel(labelId);
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int typeId) {
        return this.schemaCache.constraintsForRelationshipType(typeId);
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetAll() {
        return this.schemaCache.constraints();
    }

    @Override
    public int propertyKeyGetOrCreateForName(String propertyKey) {
        return this.propertyKeyTokenHolder.getOrCreateId(propertyKey);
    }

    @Override
    public int propertyKeyGetForName(String propertyKey) {
        return this.propertyKeyTokenHolder.getIdByName(propertyKey);
    }

    @Override
    public String propertyKeyGetName(int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        try {
            return ((Token)this.propertyKeyTokenHolder.getTokenById(propertyKeyId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new PropertyKeyIdNotFoundKernelException(propertyKeyId, (Exception)e);
        }
    }

    @Override
    public PrimitiveIntIterator graphGetPropertyKeys() {
        return new PropertyKeyIdIterator((Iterator)((Object)this.propertyLoader.graphLoadProperties(new IteratingPropertyReceiver())));
    }

    @Override
    public Object graphGetProperty(int propertyKeyId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<StorageProperty> graphGetAllProperties() {
        return (Iterator)((Object)this.propertyLoader.graphLoadProperties(new IteratingPropertyReceiver()));
    }

    @Override
    public Iterator<Token> propertyKeyGetAllTokens() {
        return this.propertyKeyTokenHolder.getAllTokens().iterator();
    }

    @Override
    public Iterator<Token> labelsGetAllTokens() {
        return this.labelTokenHolder.getAllTokens().iterator();
    }

    @Override
    public Iterator<Token> relationshipTypeGetAllTokens() {
        return this.relationshipTokenHolder.getAllTokens().iterator();
    }

    @Override
    public int relationshipTypeGetForName(String relationshipTypeName) {
        return this.relationshipTokenHolder.getIdByName(relationshipTypeName);
    }

    @Override
    public String relationshipTypeGetName(int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        try {
            return ((RelationshipTypeToken)this.relationshipTokenHolder.getTokenById(relationshipTypeId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new RelationshipTypeIdNotFoundKernelException(relationshipTypeId, e);
        }
    }

    @Override
    public int relationshipTypeGetOrCreateForName(String relationshipTypeName) {
        return this.relationshipTokenHolder.getOrCreateId(relationshipTypeName);
    }

    @Override
    public <EXCEPTION extends Exception> void relationshipVisit(long relationshipId, RelationshipVisitor<EXCEPTION> relationshipVisitor) throws EntityNotFoundException, EXCEPTION {
        RelationshipRecord record = (RelationshipRecord)this.relationshipStore.getRecord(relationshipId, this.relationshipStore.newRecord(), RecordLoad.CHECK);
        if (!record.inUse()) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationshipId);
        }
        relationshipVisitor.visit(relationshipId, record.getType(), record.getFirstNode(), record.getSecondNode());
    }

    @Override
    public PrimitiveLongIterator nodesGetAll() {
        return new AllNodeIterator(this.nodeStore);
    }

    @Override
    public RelationshipIterator relationshipsGetAll() {
        return new AllRelationshipIterator(this.relationshipStore);
    }

    @Override
    public Cursor<RelationshipItem> nodeGetRelationships(StorageStatement statement, NodeItem nodeItem, Direction direction) {
        return this.nodeGetRelationships(statement, nodeItem, direction, Predicates.ALWAYS_TRUE_INT);
    }

    @Override
    public Cursor<RelationshipItem> nodeGetRelationships(StorageStatement statement, NodeItem node, Direction direction, IntPredicate relTypes) {
        return statement.acquireNodeRelationshipCursor(node.isDense(), node.id(), node.nextRelationshipId(), direction, relTypes);
    }

    @Override
    public Cursor<PropertyItem> nodeGetProperties(StorageStatement statement, NodeItem node, AssertOpen assertOpen) {
        Lock lock = node.lock();
        return statement.acquirePropertyCursor(node.nextPropertyId(), lock, assertOpen);
    }

    @Override
    public Cursor<PropertyItem> nodeGetProperty(StorageStatement statement, NodeItem node, int propertyKeyId, AssertOpen assertOpen) {
        Lock lock = node.lock();
        return statement.acquireSinglePropertyCursor(node.nextPropertyId(), propertyKeyId, lock, assertOpen);
    }

    @Override
    public Cursor<PropertyItem> relationshipGetProperties(StorageStatement statement, RelationshipItem relationship, AssertOpen assertOpen) {
        Lock lock = relationship.lock();
        return statement.acquirePropertyCursor(relationship.nextPropertyId(), lock, assertOpen);
    }

    @Override
    public Cursor<PropertyItem> relationshipGetProperty(StorageStatement statement, RelationshipItem relationship, int propertyKeyId, AssertOpen assertOpen) {
        Lock lock = relationship.lock();
        return statement.acquireSinglePropertyCursor(relationship.nextPropertyId(), propertyKeyId, lock, assertOpen);
    }

    @Override
    public void releaseNode(long id) {
        this.nodeStore.freeId(id);
    }

    @Override
    public void releaseRelationship(long id) {
        this.relationshipStore.freeId(id);
    }

    @Override
    public long countsForNode(int labelId) {
        return this.counts.nodeCount(labelId, Registers.newDoubleLongRegister()).readSecond();
    }

    @Override
    public long countsForRelationship(int startLabelId, int typeId, int endLabelId) {
        if (startLabelId != -1 && endLabelId != -1) {
            throw new UnsupportedOperationException("not implemented");
        }
        return this.counts.relationshipCount(startLabelId, typeId, endLabelId, Registers.newDoubleLongRegister()).readSecond();
    }

    @Override
    public long nodesGetCount() {
        return this.nodeStore.getNumberOfIdsInUse();
    }

    @Override
    public long relationshipsGetCount() {
        return this.relationshipStore.getNumberOfIdsInUse();
    }

    @Override
    public int labelCount() {
        return this.labelTokenHolder.size();
    }

    @Override
    public int propertyKeyCount() {
        return this.propertyKeyTokenHolder.size();
    }

    @Override
    public int relationshipTypeCount() {
        return this.relationshipTokenHolder.size();
    }

    @Override
    public Register.DoubleLongRegister indexUpdatesAndSize(SchemaDescriptor descriptor, Register.DoubleLongRegister target) throws IndexNotFoundKernelException {
        return this.counts.indexUpdatesAndSize(this.tryGetIndexId(descriptor), target);
    }

    @Override
    public Register.DoubleLongRegister indexSample(SchemaDescriptor descriptor, Register.DoubleLongRegister target) throws IndexNotFoundKernelException {
        return this.counts.indexSample(this.tryGetIndexId(descriptor), target);
    }

    private long tryGetIndexId(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getIndexId(descriptor);
    }

    @Override
    public boolean nodeExists(long id) {
        return this.nodeStore.isInUse(id);
    }

    @Override
    public boolean relationshipExists(long id) {
        return this.relationshipStore.isInUse(id);
    }

    @Override
    public PrimitiveIntSet relationshipTypes(StorageStatement statement, NodeItem node) {
        PrimitiveIntSet set = Primitive.intSet();
        if (node.isDense()) {
            RelationshipGroupRecord groupRecord = this.relationshipGroupStore.newRecord();
            RecordCursor<RelationshipGroupRecord> cursor = statement.recordCursors().relationshipGroup();
            long id = node.nextGroupId();
            while (id != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                if (cursor.next(id, groupRecord, RecordLoad.FORCE)) {
                    set.add(groupRecord.getType());
                }
                id = groupRecord.getNext();
            }
        } else {
            this.nodeGetRelationships(statement, node, Direction.BOTH).forAll(relationship -> set.add(relationship.type()));
        }
        return set;
    }

    @Override
    public void degrees(StorageStatement statement, NodeItem nodeItem, DegreeVisitor visitor) {
        if (nodeItem.isDense()) {
            this.visitDenseNode(statement, nodeItem, visitor);
        } else {
            this.visitNode(statement, nodeItem, visitor);
        }
    }

    private IndexRule indexRule(SchemaIndexDescriptor index) {
        for (IndexRule rule : this.schemaCache.indexRules()) {
            if (!rule.getIndexDescriptor().equals(index)) continue;
            return rule;
        }
        return this.schemaStorage.indexGetForSchema(index);
    }

    @Override
    public int degreeRelationshipsInGroup(StorageStatement storeStatement, long nodeId, long groupId, Direction direction, Integer relType) {
        RelationshipRecord relationshipRecord = (RelationshipRecord)this.relationshipStore.newRecord();
        RelationshipGroupRecord relationshipGroupRecord = this.relationshipGroupStore.newRecord();
        return DegreeCounter.countRelationshipsInGroup(groupId, direction, relType, nodeId, relationshipRecord, relationshipGroupRecord, storeStatement.recordCursors());
    }

    @Override
    public <T> T getOrCreateSchemaDependantState(Class<T> type, Function<StoreReadLayer, T> factory) {
        return this.schemaCache.getOrCreateDependantState(type, factory, this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void visitNode(StorageStatement statement, NodeItem nodeItem, DegreeVisitor visitor) {
        try (Cursor<RelationshipItem> relationships = this.nodeGetRelationships(statement, nodeItem, Direction.BOTH);){
            block14: while (relationships.next()) {
                RelationshipItem rel = (RelationshipItem)relationships.get();
                int type = rel.type();
                switch (this.directionOf(nodeItem.id(), rel.id(), rel.startNode(), rel.endNode())) {
                    case OUTGOING: {
                        visitor.visitDegree(type, 1L, 0L);
                        continue block14;
                    }
                    case INCOMING: {
                        visitor.visitDegree(type, 0L, 1L);
                        continue block14;
                    }
                    case BOTH: {
                        visitor.visitDegree(type, 1L, 1L);
                        continue block14;
                    }
                }
            }
            return;
            throw new IllegalStateException("You found the missing direction!");
        }
    }

    private void visitDenseNode(StorageStatement statement, NodeItem nodeItem, DegreeVisitor visitor) {
        RelationshipGroupRecord relationshipGroupRecord = this.relationshipGroupStore.newRecord();
        RecordCursor<RelationshipGroupRecord> relationshipGroupCursor = statement.recordCursors().relationshipGroup();
        RelationshipRecord relationshipRecord = (RelationshipRecord)this.relationshipStore.newRecord();
        RecordCursor<RelationshipRecord> relationshipCursor = statement.recordCursors().relationship();
        long groupId = nodeItem.nextGroupId();
        while (groupId != Record.NO_NEXT_RELATIONSHIP.longValue()) {
            relationshipGroupCursor.next(groupId, relationshipGroupRecord, RecordLoad.FORCE);
            if (relationshipGroupRecord.inUse()) {
                int type = relationshipGroupRecord.getType();
                long firstLoop = relationshipGroupRecord.getFirstLoop();
                long firstOut = relationshipGroupRecord.getFirstOut();
                long firstIn = relationshipGroupRecord.getFirstIn();
                long loop = DegreeCounter.countByFirstPrevPointer(firstLoop, relationshipCursor, nodeItem.id(), relationshipRecord);
                long outgoing = DegreeCounter.countByFirstPrevPointer(firstOut, relationshipCursor, nodeItem.id(), relationshipRecord) + loop;
                long incoming = DegreeCounter.countByFirstPrevPointer(firstIn, relationshipCursor, nodeItem.id(), relationshipRecord) + loop;
                visitor.visitDegree(type, outgoing, incoming);
            }
            groupId = relationshipGroupRecord.getNext();
        }
    }

    private Direction directionOf(long nodeId, long relationshipId, long startNode, long endNode) {
        if (startNode == nodeId) {
            return endNode == nodeId ? Direction.BOTH : Direction.OUTGOING;
        }
        if (endNode == nodeId) {
            return Direction.INCOMING;
        }
        throw new InvalidRecordException("Node " + nodeId + " neither start nor end node of relationship " + relationshipId + " with startNode:" + startNode + " and endNode:" + endNode);
    }

    private static Iterator<SchemaIndexDescriptor> toIndexDescriptors(Iterable<IndexRule> rules) {
        return Iterators.map(IndexRule::getIndexDescriptor, rules.iterator());
    }
}

