/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.io.File;
import java.time.Duration;
import java.util.List;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.Dynamic;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.configuration.ReplacedBy;
import org.neo4j.graphdb.config.BaseSetting;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.configuration.BoltConnectorValidator;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.configuration.GraphDatabaseConfigurationMigrator;
import org.neo4j.kernel.configuration.Group;
import org.neo4j.kernel.configuration.GroupSettingSupport;
import org.neo4j.kernel.configuration.HttpConnectorValidator;
import org.neo4j.kernel.configuration.Migrator;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.kernel.configuration.Title;
import org.neo4j.kernel.configuration.ssl.SslPolicyConfigValidator;
import org.neo4j.logging.Level;
import org.neo4j.logging.LogTimeZone;

public class GraphDatabaseSettings
implements LoadableConfig {
    public static final int DEFAULT_BLOCK_SIZE = 128;
    public static final int DEFAULT_LABEL_BLOCK_SIZE = 64;
    public static final int MINIMAL_BLOCK_SIZE = 16;
    public static final long UNSPECIFIED_TIMEOUT = 0L;
    @Migrator
    private static final ConfigurationMigrator migrator = new GraphDatabaseConfigurationMigrator();
    @Internal
    @Description(value="Root relative to which directory settings are resolved. This is set in code and should never be configured explicitly.")
    public static final Setting<File> neo4j_home = Settings.setting("unsupported.dbms.directories.neo4j_home", Settings.PATH, Settings.NO_DEFAULT);
    @Description(value="Name of the database to load")
    public static final Setting<String> active_database = Settings.setting("dbms.active_database", Settings.STRING, "graph.db");
    @Description(value="Path of the data directory. You must not configure more than one Neo4j installation to use the same data directory.")
    public static final Setting<File> data_directory = Settings.pathSetting("dbms.directories.data", "data");
    @Internal
    public static final Setting<File> database_path = Settings.derivedSetting("unsupported.dbms.directories.database", data_directory, active_database, (data, current) -> new File(new File((File)data, "databases"), (String)current), Settings.PATH);
    @Title(value="Read only database")
    @Description(value="Only allow read operations from this Neo4j instance. This mode still requires write access to the directory for lock purposes.")
    public static final Setting<Boolean> read_only = Settings.setting("dbms.read_only", Settings.BOOLEAN, "false");
    @Title(value="Disconnected")
    @Internal
    @Description(value="Disable all protocol connectors.")
    public static final Setting<Boolean> disconnected = Settings.setting("unsupported.dbms.disconnected", Settings.BOOLEAN, "false");
    @Description(value="Print out the effective Neo4j configuration after startup.")
    @Internal
    public static final Setting<Boolean> dump_configuration = Settings.setting("unsupported.dbms.report_configuration", Settings.BOOLEAN, "false");
    @Description(value="A strict configuration validation will prevent the database from starting up if unknown configuration options are specified in the neo4j settings namespace (such as dbms., ha., cypher., etc). This is currently false by default but will be true by default in 4.0.")
    public static final Setting<Boolean> strict_config_validation = Settings.setting("dbms.config.strict_validation", Settings.BOOLEAN, "false");
    @Description(value="Whether to allow a store upgrade in case the current version of the database starts against an older store version. Setting this to `true` does not guarantee successful upgrade, it just allows an upgrade to be performed.")
    @Deprecated
    @ReplacedBy(value="dbms.allow_upgrade")
    public static final Setting<Boolean> allow_store_upgrade = Settings.setting("dbms.allow_format_migration", Settings.BOOLEAN, "false");
    @Description(value="Whether to allow an upgrade in case the current version of the database starts against an older version.")
    public static final Setting<Boolean> allow_upgrade = Settings.setting("dbms.allow_upgrade", Settings.BOOLEAN, "false");
    @Description(value="Database record format. Valid values: `standard`, `high_limit`. The `high_limit` format\u00a0is available for Enterprise Edition only. It is required if you have a graph that is larger than 34 billion nodes, 34 billion relationships, or 68 billion properties. A change of the record format is irreversible. Certain operations may suffer from a performance penalty of up to 10%, which is why this format is not switched on by default.")
    public static final Setting<String> record_format = Settings.setting("dbms.record_format", Settings.STRING, "");
    @Description(value="Set this to specify the default parser (language version).")
    public static final Setting<String> cypher_parser_version = Settings.setting("cypher.default_language_version", Settings.options("2.3", "3.1", "3.3", "3.4", "default"), "default");
    @Description(value="Set this to specify the default planner for the default language version.")
    public static final Setting<String> cypher_planner = Settings.setting("cypher.planner", Settings.options("COST", "RULE", "default"), "default");
    @Description(value="Set this to specify the behavior when Cypher planner or runtime hints cannot be fulfilled. If true, then non-conformance will result in an error, otherwise only a warning is generated.")
    public static final Setting<Boolean> cypher_hints_error = Settings.setting("cypher.hints_error", Settings.BOOLEAN, "false");
    @Description(value="This setting is associated with performance optimization. Set this to `true` in situations where it is preferable to have any queries using the 'shortestPath' function terminate as soon as possible with no answer, rather than potentially running for a long time attempting to find an answer (even if there is no path to be found). For most queries, the 'shortestPath' algorithm will return the correct answer very quickly. However there are some cases where it is possible that the fast bidirectional breadth-first search algorithm will find no results even if they exist. This can happen when the predicates in the `WHERE` clause applied to 'shortestPath' cannot be applied to each step of the traversal, and can only be applied to the entire path. When the query planner detects these special cases, it will plan to perform an exhaustive depth-first search if the fast algorithm finds no paths. However, the exhaustive search may be orders of magnitude slower than the fast algorithm. If it is critical that queries terminate as soon as possible, it is recommended that this option be set to `true`, which means that Neo4j will never consider using the exhaustive search for shortestPath queries. However, please note that if no paths are found, an error will be thrown at run time, which will need to be handled by the application.")
    public static final Setting<Boolean> forbid_exhaustive_shortestpath = Settings.setting("cypher.forbid_exhaustive_shortestpath", Settings.BOOLEAN, "false");
    @Description(value="This setting is associated with performance optimization. The shortest path algorithm does not work when the start and end nodes are the same. With this setting set to `false` no path will be returned when that happens. The default value of `true` will instead throw an exception. This can happen if you perform a shortestPath search after a cartesian product that might have the same start and end nodes for some of the rows passed to shortestPath. If it is preferable to not experience this exception, and acceptable for results to be missing for those rows, then set this to `false`. If you cannot accept missing results, and really want the shortestPath between two common nodes, then re-write the query using a standard Cypher variable length pattern expression followed by ordering by path length and limiting to one result.")
    public static final Setting<Boolean> forbid_shortestpath_common_nodes = Settings.setting("cypher.forbid_shortestpath_common_nodes", Settings.BOOLEAN, "true");
    @Description(value="Set this to specify the default runtime for the default language version.")
    @Internal
    public static final Setting<String> cypher_runtime = Settings.setting("unsupported.cypher.runtime", Settings.options("INTERPRETED", "COMPILED", "SLOTTED", "MORSEL", "default"), "default");
    @Description(value="Enable tracing of compilation in cypher.")
    @Internal
    public static final Setting<Boolean> cypher_compiler_tracing = Settings.setting("unsupported.cypher.compiler_tracing", Settings.BOOLEAN, "false");
    @Description(value="The number of Cypher query execution plans that are cached.")
    public static final Setting<Integer> query_cache_size = Settings.buildSetting("dbms.query_cache_size", Settings.INTEGER, "1000").constraint(Settings.min(0)).build();
    @Description(value="The threshold when a plan is considered stale. If any of the underlying statistics used to create the plan have changed more than this value, the plan will be considered stale and will be replanned. Change is calculated as abs(a-b)/max(a,b). This means that a value of 0.75 requires the database to approximately quadruple in size. A value of 0 means replan as soon as possible, with the soonest being defined by the cypher.min_replan_interval which defaults to 10s. After this interval the divergence threshold will slowly start to decline, reaching 10% after about 7h. This will ensure that long running databases will still get query replanning on even modest changes, while not replanning frequently unless the changes are very large.")
    public static final Setting<Double> query_statistics_divergence_threshold = Settings.buildSetting("cypher.statistics_divergence_threshold", Settings.DOUBLE, "0.75").constraint(Settings.range(0.0, 1.0)).build();
    @Description(value="Large databases might change slowly, and so to prevent queries from never being replanned the divergence threshold set by cypher.statistics_divergence_threshold is configured to shrink over time. The algorithm used to manage this change is set by unsupported.cypher.replan_algorithm and will cause the threshold to reach the value set here once the time since the previous replanning has reached unsupported.cypher.target_replan_interval. Setting this value to higher than the cypher.statistics_divergence_threshold will cause the threshold to not decay over time.")
    @Internal
    public static final Setting<Double> query_statistics_divergence_target = Settings.buildSetting("unsupported.cypher.statistics_divergence_target", Settings.DOUBLE, "0.10").constraint(Settings.range(0.0, 1.0)).build();
    @Description(value="The threshold when a warning is generated if a label scan is done after a load csv where the label has no index")
    @Internal
    public static final Setting<Long> query_non_indexed_label_warning_threshold = Settings.setting("unsupported.cypher.non_indexed_label_warning_threshold", Settings.LONG, "10000");
    @Description(value="To improve IDP query planning time, we can restrict the internal planning table size, triggering compaction of candidate plans. The smaller the threshold the faster the planning, but the higher the risk of sub-optimal plans.")
    @Internal
    public static final Setting<Integer> cypher_idp_solver_table_threshold = Settings.buildSetting("unsupported.cypher.idp_solver_table_threshold", Settings.INTEGER, "128").constraint(Settings.min(16)).build();
    @Description(value="To improve IDP query planning time, we can restrict the internal planning loop duration, triggering more frequent compaction of candidate plans. The smaller the threshold the faster the planning, but the higher the risk of sub-optimal plans.")
    @Internal
    public static final Setting<Long> cypher_idp_solver_duration_threshold = Settings.buildSetting("unsupported.cypher.idp_solver_duration_threshold", Settings.LONG, "1000").constraint(Settings.min(10L)).build();
    @Description(value="The minimum time between possible cypher query replanning events. After this time, the graph statistics will be evaluated, and if they have changed by more than the value set by cypher.statistics_divergence_threshold, the query will be replanned. If the statistics have not changed sufficiently, the same interval will need to pass before the statistics will be evaluated again. Each time they are evaluated, the divergence threshold will be reduced slightly until it reaches 10% after 7h, so that even moderately changing databases will see query replanning after a sufficiently long time interval.")
    public static final Setting<Duration> cypher_min_replan_interval = Settings.setting("cypher.min_replan_interval", Settings.DURATION, "10s");
    @Description(value="Large databases might change slowly, and to prevent queries from never being replanned the divergence threshold set by cypher.statistics_divergence_threshold is configured to shrink over time. The algorithm used to manage this change is set by unsupported.cypher.replan_algorithm and will cause the threshold to reach the value set by unsupported.cypher.statistics_divergence_target once the time since the previous replanning has reached the value set here. Setting this value to less than the value of cypher.min_replan_interval will cause the threshold to not decay over time.")
    @Internal
    public static final Setting<Duration> cypher_replan_interval_target = Settings.setting("unsupported.cypher.target_replan_interval", Settings.DURATION, "7h");
    @Description(value="Large databases might change slowly, and to prevent queries from never being replanned the divergence threshold set by cypher.statistics_divergence_threshold is configured to shrink over time using the algorithm set here. This will cause the threshold to reach the value set by unsupported.cypher.statistics_divergence_target once the time since the previous replanning has reached the value set in unsupported.cypher.target_replan_interval. Setting the algorithm to 'none' will cause the threshold to not decay over time.")
    @Internal
    public static final Setting<String> cypher_replan_algorithm = Settings.setting("unsupported.cypher.replan_algorithm", Settings.options("inverse", "exponential", "none", "default"), "default");
    @Description(value="Determines if Cypher will allow using file URLs when loading data using `LOAD CSV`. Setting this value to `false` will cause Neo4j to fail `LOAD CSV` clauses that load data from the file system.")
    public static final Setting<Boolean> allow_file_urls = Settings.setting("dbms.security.allow_csv_import_from_file_urls", Settings.BOOLEAN, "true");
    @Description(value="Sets the root directory for file URLs used with the Cypher `LOAD CSV` clause. This must be set to a single directory, restricting access to only those files within that directory and its subdirectories.")
    public static final Setting<File> load_csv_file_url_root = Settings.pathSetting("dbms.directories.import", Settings.NO_DEFAULT);
    @Description(value="Selects whether to conform to the standard https://tools.ietf.org/html/rfc4180 for interpreting escaped quotation characters in CSV files loaded using `LOAD CSV`. Setting this to `false` will use the standard, interpreting repeated quotes '\"\"' as a single in-lined quote, while `true` will use the legacy convention originally supported in Neo4j 3.0 and 3.1, allowing a backslash to include quotes in-lined in fields.")
    public static final Setting<Boolean> csv_legacy_quote_escaping = Settings.setting("dbms.import.csv.legacy_quote_escaping", Settings.BOOLEAN, Boolean.toString(true));
    @Description(value="Enables or disables tracking of how much time a query spends actively executing on the CPU.")
    @Dynamic
    public static final Setting<Boolean> track_query_cpu_time = Settings.setting("dbms.track_query_cpu_time", Settings.BOOLEAN, "true");
    @Description(value="Enables or disables tracking of how many bytes are allocated by the execution of a query.")
    @Dynamic
    public static final Setting<Boolean> track_query_allocation = Settings.setting("dbms.track_query_allocation", Settings.BOOLEAN, "true");
    @Description(value="The size of the morsels")
    @Internal
    public static final Setting<Integer> cypher_morsel_size = Settings.setting("unsupported.cypher.morsel_size", Settings.INTEGER, "10000");
    @Description(value="Number of threads to allocate to Cypher worker threads. If set to 0, two workers will be started for every physical core in the system.")
    @Internal
    public static final Setting<Integer> cypher_worker_count = Settings.setting("unsupported.cypher.number_of_workers", Settings.INTEGER, "0");
    @Description(value="The maximum amount of time to wait for the database to become available, when starting a new transaction.")
    @Internal
    public static final Setting<Duration> transaction_start_timeout = Settings.setting("unsupported.dbms.transaction_start_timeout", Settings.DURATION, "1s");
    @Internal
    @Description(value="Please use dbms.transaction.timeout instead.")
    @Deprecated
    @ReplacedBy(value="dbms.transaction.timeout")
    public static final Setting<Boolean> execution_guard_enabled = Settings.setting("unsupported.dbms.executiontime_limit.enabled", Settings.BOOLEAN, "false");
    @Description(value="The maximum time interval of a transaction within which it should be completed.")
    @Dynamic
    public static final Setting<Duration> transaction_timeout = Settings.setting("dbms.transaction.timeout", Settings.DURATION, String.valueOf(0L));
    @Description(value="The maximum time interval within which lock should be acquired.")
    public static final Setting<Duration> lock_acquisition_timeout = Settings.setting("dbms.lock.acquisition.timeout", Settings.DURATION, String.valueOf(0L));
    @Description(value="Configures the time interval between transaction monitor checks. Determines how often monitor thread will check transaction for timeout.")
    public static final Setting<Duration> transaction_monitor_check_interval = Settings.setting("dbms.transaction.monitor.check.interval", Settings.DURATION, "2s");
    @Description(value="The maximum amount of time to wait for running transactions to complete before allowing initiated database shutdown to continue")
    public static final Setting<Duration> shutdown_transaction_end_timeout = Settings.setting("dbms.shutdown_transaction_end_timeout", Settings.DURATION, "10s");
    @Description(value="Location of the database plugin directory. Compiled Java JAR files that contain database procedures will be loaded if they are placed in this directory.")
    public static final Setting<File> plugin_dir = Settings.pathSetting("dbms.directories.plugins", "plugins");
    @Description(value="Threshold for rotation of the debug log.")
    public static final Setting<Long> store_internal_log_rotation_threshold = Settings.buildSetting("dbms.logs.debug.rotation.size", Settings.BYTES, "20m").constraint(Settings.range(0L, Long.MAX_VALUE)).build();
    @Description(value="Debug log contexts that should output debug level logging")
    @Internal
    public static final Setting<List<String>> store_internal_debug_contexts = Settings.setting("unsupported.dbms.logs.debug.debug_loggers", Settings.list(",", Settings.STRING), "org.neo4j.diagnostics,org.neo4j.cluster.protocol,org.neo4j.kernel.ha");
    @Description(value="Debug log level threshold.")
    public static final Setting<Level> store_internal_log_level = Settings.setting("dbms.logs.debug.level", Settings.options(Level.class), "INFO");
    @Description(value="Database timezone.")
    public static final Setting<LogTimeZone> db_timezone = Settings.setting("dbms.db.timezone", Settings.options(LogTimeZone.class), LogTimeZone.UTC.name());
    @Description(value="Database logs timezone.")
    @Deprecated
    @ReplacedBy(value="dbms.db.timezone")
    public static final Setting<LogTimeZone> log_timezone = Settings.setting("dbms.logs.timezone", Settings.options(LogTimeZone.class), LogTimeZone.UTC.name());
    @Description(value="Maximum time to wait for active transaction completion when rotating counts store")
    @Internal
    public static final Setting<Duration> counts_store_rotation_timeout = Settings.setting("unsupported.dbms.counts_store_rotation_timeout", Settings.DURATION, "10m");
    @Description(value="Minimum time interval after last rotation of the debug log before it may be rotated again.")
    public static final Setting<Duration> store_internal_log_rotation_delay = Settings.setting("dbms.logs.debug.rotation.delay", Settings.DURATION, "300s");
    @Description(value="Maximum number of history files for the debug log.")
    public static final Setting<Integer> store_internal_log_max_archives = Settings.buildSetting("dbms.logs.debug.rotation.keep_number", Settings.INTEGER, "7").constraint(Settings.min(1)).build();
    @Description(value="Configures the general policy for when check-points should occur. The default policy is the 'periodic' check-point policy, as specified by the 'dbms.checkpoint.interval.tx' and 'dbms.checkpoint.interval.time' settings. The Neo4j Enterprise Edition provides two alternative policies: The first is the 'continuous' check-point policy, which will ignore those settings and run the check-point process all the time. The second is the 'volumetric' check-point policy, which makes a best-effort at check-pointing often enough so that the database doesn't get too far behind on deleting old transaction logs in accordance with the 'dbms.tx_log.rotation.retention_policy' setting.")
    public static final Setting<String> check_point_policy = Settings.setting("dbms.checkpoint", Settings.STRING, "periodic");
    @Description(value="Configures the transaction interval between check-points. The database will not check-point more often  than this (unless check pointing is triggered by a different event), but might check-point less often than this interval, if performing a check-point takes longer time than the configured interval. A check-point is a point in the transaction logs, from which recovery would start from. Longer check-point intervals typically means that recovery will take longer to complete in case of a crash. On the other hand, a longer check-point interval can also reduce the I/O load that the database places on the system, as each check-point implies a flushing and forcing of all the store files.  The default is '100000' for a check-point every 100000 transactions.")
    public static final Setting<Integer> check_point_interval_tx = Settings.buildSetting("dbms.checkpoint.interval.tx", Settings.INTEGER, "100000").constraint(Settings.min(1)).build();
    @Description(value="Configures the time interval between check-points. The database will not check-point more often than this (unless check pointing is triggered by a different event), but might check-point less often than this interval, if performing a check-point takes longer time than the configured interval. A check-point is a point in the transaction logs, from which recovery would start from. Longer check-point intervals typically means that recovery will take longer to complete in case of a crash. On the other hand, a longer check-point interval can also reduce the I/O load that the database places on the system, as each check-point implies a flushing and forcing of all the store files.")
    public static final Setting<Duration> check_point_interval_time = Settings.setting("dbms.checkpoint.interval.time", Settings.DURATION, "15m");
    @Dynamic
    @Description(value="Limit the number of IOs the background checkpoint process will consume per second. This setting is advisory, is ignored in Neo4j Community Edition, and is followed to best effort in Enterprise Edition. An IO is in this case a 8 KiB (mostly sequential) write. Limiting the write IO in this way will leave more bandwidth in the IO subsystem to service random-read IOs, which is important for the response time of queries when the database cannot fit entirely in memory. The only drawback of this setting is that longer checkpoint times may lead to slightly longer recovery times in case of a database or system crash. A lower number means lower IO pressure, and consequently longer checkpoint times. The configuration can also be commented out to remove the limitation entirely, and let the checkpointer flush data as fast as the hardware will go. Set this to -1 to disable the IOPS limit.")
    public static final Setting<Integer> check_point_iops_limit = Settings.setting("dbms.checkpoint.iops.limit", Settings.INTEGER, "300");
    @Description(value="Controls the auto indexing feature for nodes. Setting it to `false` shuts it down, while `true` enables it by default for properties listed in the dbms.auto_index.nodes.keys setting.")
    @Internal
    @Deprecated
    public static final Setting<Boolean> node_auto_indexing = Settings.setting("dbms.auto_index.nodes.enabled", Settings.BOOLEAN, "false");
    @Description(value="A list of property names (comma separated) that will be indexed by default. This applies to _nodes_ only.")
    @Internal
    @Deprecated
    public static final Setting<List<String>> node_keys_indexable = Settings.setting("dbms.auto_index.nodes.keys", Settings.STRING_LIST, "");
    @Description(value="Controls the auto indexing feature for relationships. Setting it to `false` shuts it down, while `true` enables it by default for properties listed in the dbms.auto_index.relationships.keys setting.")
    @Internal
    @Deprecated
    public static final Setting<Boolean> relationship_auto_indexing = Settings.setting("dbms.auto_index.relationships.enabled", Settings.BOOLEAN, "false");
    @Description(value="A list of property names (comma separated) that will be indexed by default. This applies to _relationships_ only.")
    @Internal
    @Deprecated
    public static final Setting<List<String>> relationship_keys_indexable = Settings.setting("dbms.auto_index.relationships.keys", Settings.STRING_LIST, "");
    @Description(value="Enable or disable background index sampling")
    public static final Setting<Boolean> index_background_sampling_enabled = Settings.setting("dbms.index_sampling.background_enabled", Settings.BOOLEAN, "true");
    @Description(value="Size of buffer used by index sampling. This configuration setting is no longer applicable as from Neo4j 3.0.3. Please use dbms.index_sampling.sample_size_limit instead.")
    @Deprecated
    @ReplacedBy(value="dbms.index_sampling.sample_size_limit")
    public static final Setting<Long> index_sampling_buffer_size = Settings.buildSetting("dbms.index_sampling.buffer_size", Settings.BYTES, "64m").constraint(Settings.range(0x100000L, Integer.MAX_VALUE)).build();
    @Description(value="Index sampling chunk size limit")
    public static final Setting<Integer> index_sample_size_limit = Settings.buildSetting("dbms.index_sampling.sample_size_limit", Settings.INTEGER, String.valueOf(ByteUnit.mebiBytes((long)8L))).constraint(Settings.range((int)ByteUnit.mebiBytes((long)1L), Integer.MAX_VALUE)).build();
    @Description(value="Percentage of index updates of total index size required before sampling of a given index is triggered")
    public static final Setting<Integer> index_sampling_update_percentage = Settings.buildSetting("dbms.index_sampling.update_percentage", Settings.INTEGER, "5").constraint(Settings.min(0)).build();
    @Description(value="The maximum number of open Lucene index searchers.")
    public static final Setting<Integer> lucene_searcher_cache_size = Settings.buildSetting("dbms.index_searcher_cache_size", Settings.INTEGER, Integer.toString(Integer.MAX_VALUE)).constraint(Settings.min(1)).build();
    @Internal
    public static final Setting<Boolean> multi_threaded_schema_index_population_enabled = Settings.setting("unsupported.dbms.multi_threaded_schema_index_population_enabled", Settings.BOOLEAN, "true");
    @Deprecated
    @ReplacedBy(value="dbms.index.default_schema_provider")
    @Internal
    public static final Setting<Boolean> enable_native_schema_index = Settings.setting("unsupported.dbms.enable_native_schema_index", Settings.BOOLEAN, "true");
    @Description(value="Index provider to use when creating new indexes.")
    public static final Setting<String> default_schema_provider = Settings.setting("dbms.index.default_schema_provider", Settings.optionsIgnoreCase(SchemaIndex.NATIVE20.param(), SchemaIndex.NATIVE10.param(), SchemaIndex.LUCENE10.param()), null);
    @Description(value="Location where Neo4j keeps the logical transaction logs.")
    public static final Setting<File> logical_logs_location = Settings.pathSetting("dbms.directories.tx_log", "", database_path);
    @Description(value="Make Neo4j keep the logical transaction logs for being able to backup the database. Can be used for specifying the threshold to prune logical logs after. For example \"10 days\" will prune logical logs that only contains transactions older than 10 days from the current time, or \"100k txs\" will keep the 100k latest transactions and prune any older transactions.")
    @Dynamic
    public static final Setting<String> keep_logical_logs = Settings.buildSetting("dbms.tx_log.rotation.retention_policy", Settings.STRING, "7 days").constraint(Settings.illegalValueMessage("must be `true`, `false` or of format `<number><optional unit> <type>`. Valid units are `k`, `M` and `G`. Valid types are `files`, `size`, `txs`, `entries`, `hours` and `days`. For example, `100M size` will limiting logical log space on disk to 100Mb, or `200k txs` will limiting the number of transactions to keep to 200 000", Settings.matches("^(true|keep_all|false|keep_none|(\\d+[KkMmGg]?( (files|size|txs|entries|hours|days))))$"))).build();
    @Description(value="Specifies at which file size the logical log will auto-rotate. Minimum accepted value is 1M. ")
    @Dynamic
    public static final Setting<Long> logical_log_rotation_threshold = Settings.buildSetting("dbms.tx_log.rotation.size", Settings.BYTES, "250M").constraint(Settings.min(ByteUnit.mebiBytes((long)1L))).build();
    @Description(value="Use a quick approach for rebuilding the ID generators. This give quicker recovery time, but will limit the ability to reuse the space of deleted entities.")
    @Internal
    public static final Setting<Boolean> rebuild_idgenerators_fast = Settings.setting("unsupported.dbms.id_generator_fast_rebuild_enabled", Settings.BOOLEAN, "true");
    @Description(value="Specifies if engine should run cypher query based on a snapshot of accessed data. Query will be restarted in case if concurrent modification of data will be detected.")
    @Internal
    public static final Setting<Boolean> snapshot_query = Settings.setting("unsupported.dbms.query.snapshot", Settings.BOOLEAN, "false");
    @Description(value="Specifies number or retries that query engine will do to execute query based on stable accessed data snapshot before giving up.")
    @Internal
    public static final Setting<Integer> snapshot_query_retries = Settings.buildSetting("unsupported.dbms.query.snapshot.retries", Settings.INTEGER, "5").constraint(Settings.range(1, Integer.MAX_VALUE)).build();
    @Description(value="Target size for pages of mapped memory. If set to 0, then a reasonable default is chosen, depending on the storage device used.")
    @Internal
    @Deprecated
    public static final Setting<Long> mapped_memory_page_size = Settings.setting("unsupported.dbms.memory.pagecache.pagesize", Settings.BYTES, "0");
    @Description(value="The amount of memory to use for mapping the store files, in bytes (or kilobytes with the 'k' suffix, megabytes with 'm' and gigabytes with 'g'). If Neo4j is running on a dedicated server, then it is generally recommended to leave about 2-4 gigabytes for the operating system, give the JVM enough heap to hold all your transaction state and query context, and then leave the rest for the page cache. If no page cache memory is configured, then a heuristic setting is computed based on available system resources.")
    public static final Setting<String> pagecache_memory = Settings.buildSetting("dbms.memory.pagecache.size", Settings.STRING, null).build();
    @Description(value="Specify which page swapper to use for doing paged IO. This is only used when integrating with proprietary storage technology.")
    public static final Setting<String> pagecache_swapper = Settings.setting("dbms.memory.pagecache.swapper", Settings.STRING, null);
    @Internal
    @Description(value="The profiling frequency for the page cache. Accurate profiles allow the page cache to do active warmup after a restart, reducing the mean time to performance. This feature available in Neo4j Enterprise Edition.")
    public static final Setting<Duration> pagecache_warmup_profiling_interval = Settings.setting("unsupported.dbms.memory.pagecache.warmup.profile.interval", Settings.DURATION, "1m");
    @Internal
    @Description(value="Page cache can be configured to perform usage sampling of loaded pages that can be used to construct active load profile. According to that profile pages can be reloaded on the restart, replication, etc. This setting allows disabling that behavior. This feature available in Neo4j Enterprise Edition.")
    public static final Setting<Boolean> pagecache_warmup_enabled = Settings.setting("unsupported.dbms.memory.pagecache.warmup.enable", Settings.BOOLEAN, "true");
    @Description(value="Specifies the block size for storing strings. This parameter is only honored when the store is created, otherwise it is ignored. Note that each character in a string occupies two bytes, meaning that e.g a block size of 120 will hold a 60 character long string before overflowing into a second block. Also note that each block carries a ~10B of overhead so record size on disk will be slightly larger than the configured block size")
    @Internal
    public static final Setting<Integer> string_block_size = Settings.buildSetting("unsupported.dbms.block_size.strings", Settings.INTEGER, "0").constraint(Settings.min(0)).build();
    @Description(value="Specifies the block size for storing arrays. This parameter is only honored when the store is created, otherwise it is ignored. Also note that each block carries a ~10B of overhead so record size on disk will be slightly larger than the configured block size")
    @Internal
    public static final Setting<Integer> array_block_size = Settings.buildSetting("unsupported.dbms.block_size.array_properties", Settings.INTEGER, "0").constraint(Settings.min(0)).build();
    @Description(value="Specifies the block size for storing labels exceeding in-lined space in node record. This parameter is only honored when the store is created, otherwise it is ignored. Also note that each block carries a ~10B of overhead so record size on disk will be slightly larger than the configured block size")
    @Internal
    public static final Setting<Integer> label_block_size = Settings.buildSetting("unsupported.dbms.block_size.labels", Settings.INTEGER, "0").constraint(Settings.min(0)).build();
    @Description(value="Specifies the size of id batches local to each transaction when committing. Committing a transaction which contains changes most often results in new data records being created. For each record a new id needs to be generated from an id generator. It's more efficient to allocate a batch of ids from the contended id generator, which the transaction holds and generates ids from while creating these new records. This setting specifies how big those batches are. Remaining ids are freed back to id generator on clean shutdown.")
    @Internal
    public static final Setting<Integer> record_id_batch_size = Settings.buildSetting("unsupported.dbms.record_id_batch_size", Settings.INTEGER, "20").constraint(Settings.range(1, 1000)).build();
    @Description(value="An identifier that uniquely identifies this graph database instance within this JVM. Defaults to an auto-generated number depending on how many instance are started in this JVM.")
    @Internal
    public static final Setting<String> forced_kernel_id = Settings.buildSetting("unsupported.dbms.kernel_id", Settings.STRING, Settings.NO_DEFAULT).constraint(Settings.illegalValueMessage("has to be a valid kernel identifier", Settings.matches("[a-zA-Z0-9]*"))).build();
    @Internal
    public static final Setting<Duration> vm_pause_monitor_measurement_duration = Settings.setting("unsupported.vm_pause_monitor.measurement_duration", Settings.DURATION, "100ms");
    @Internal
    public static final Setting<Duration> vm_pause_monitor_stall_alert_threshold = Settings.setting("unsupported.vm_pause_monitor.stall_alert_threshold", Settings.DURATION, "100ms");
    @Description(value="Relationship count threshold for considering a node to be dense")
    public static final Setting<Integer> dense_node_threshold = Settings.buildSetting("dbms.relationship_grouping_threshold", Settings.INTEGER, "50").constraint(Settings.min(1)).build();
    @Description(value="Log executed queries that take longer than the configured threshold, dbms.logs.query.threshold. Log entries are by default written to the file _query.log_ located in the Logs directory. For location of the Logs directory, see <<file-locations>>. This feature is available in the Neo4j Enterprise Edition.")
    @Dynamic
    public static final Setting<Boolean> log_queries = Settings.setting("dbms.logs.query.enabled", Settings.BOOLEAN, "false");
    @Description(value="Path of the logs directory.")
    public static final Setting<File> logs_directory = Settings.pathSetting("dbms.directories.logs", "logs");
    @Description(value="Path to the query log file.")
    public static final Setting<File> log_queries_filename = Settings.derivedSetting("dbms.logs.query.path", logs_directory, logs -> new File((File)logs, "query.log"), Settings.PATH);
    @Description(value="Path to the debug log file.")
    public static final Setting<File> store_internal_log_path = Settings.derivedSetting("dbms.logs.debug.path", logs_directory, logs -> new File((File)logs, "debug.log"), Settings.PATH);
    @Description(value="Log parameters for the executed queries being logged.")
    public static final Setting<Boolean> log_queries_parameter_logging_enabled = Settings.setting("dbms.logs.query.parameter_logging_enabled", Settings.BOOLEAN, "true");
    @Description(value="Log detailed time information for the executed queries being logged.")
    public static final Setting<Boolean> log_queries_detailed_time_logging_enabled = Settings.setting("dbms.logs.query.time_logging_enabled", Settings.BOOLEAN, "false");
    @Description(value="Log allocated bytes for the executed queries being logged. The logged number is cumulative over the duration of the query, i.e. for memory intense or long-running queries the value may be larger than the current memory allocation.")
    public static final Setting<Boolean> log_queries_allocation_logging_enabled = Settings.setting("dbms.logs.query.allocation_logging_enabled", Settings.BOOLEAN, "false");
    @Description(value="Logs which runtime that was used to run the query")
    public static final Setting<Boolean> log_queries_runtime_logging_enabled = Settings.setting("dbms.logs.query.runtime_logging_enabled", Settings.BOOLEAN, "false");
    @Description(value="Log page hits and page faults for the executed queries being logged.")
    public static final Setting<Boolean> log_queries_page_detail_logging_enabled = Settings.setting("dbms.logs.query.page_logging_enabled", Settings.BOOLEAN, "false");
    @Description(value="If the execution of query takes more time than this threshold, the query is logged - provided query logging is enabled. Defaults to 0 seconds, that is all queries are logged.")
    @Dynamic
    public static final Setting<Duration> log_queries_threshold = Settings.setting("dbms.logs.query.threshold", Settings.DURATION, "0s");
    @Description(value="The file size in bytes at which the query log will auto-rotate. If set to zero then no rotation will occur. Accepts a binary suffix `k`, `m` or `g`.")
    @Dynamic
    public static final Setting<Long> log_queries_rotation_threshold = Settings.buildSetting("dbms.logs.query.rotation.size", Settings.BYTES, "20m").constraint(Settings.range(0L, Long.MAX_VALUE)).build();
    @Description(value="Maximum number of history files for the query log.")
    @Dynamic
    public static final Setting<Integer> log_queries_max_archives = Settings.buildSetting("dbms.logs.query.rotation.keep_number", Settings.INTEGER, "7").constraint(Settings.min(1)).build();
    @Description(value="Specifies number of operations that batch inserter will try to group into one batch before flushing data into underlying storage.")
    @Internal
    public static final Setting<Integer> batch_inserter_batch_size = Settings.setting("unsupported.tools.batch_inserter.batch_size", Settings.INTEGER, "10000");
    @Deprecated
    @Description(value="Backend to use for label --> nodes index")
    @Internal
    public static final Setting<String> label_index = Settings.setting("dbms.label_index", Settings.optionsIgnoreCase(LabelIndex.NATIVE.name(), LabelIndex.AUTO.name()), LabelIndex.NATIVE.name());
    @Description(value="Enable auth requirement to access Neo4j.")
    public static final Setting<Boolean> auth_enabled = Settings.setting("dbms.security.auth_enabled", Settings.BOOLEAN, "false");
    @Internal
    public static final Setting<File> auth_store = Settings.pathSetting("unsupported.dbms.security.auth_store.location", Settings.NO_DEFAULT);
    @Internal
    public static final Setting<Integer> auth_max_failed_attempts = Settings.buildSetting("unsupported.dbms.security.auth_max_failed_attempts", Settings.INTEGER, "3").constraint(Settings.min(0)).build();
    @Description(value="A list of procedures and user defined functions (comma separated) that are allowed full access to the database. The list may contain both fully-qualified procedure names, and partial names with the wildcard '*'. Note that this enables these procedures to bypass security. Use with caution.")
    public static final Setting<String> procedure_unrestricted = Settings.setting("dbms.security.procedures.unrestricted", Settings.STRING, "");
    @Description(value="Specifies whether or not dbms.killQueries produces a verbose output, with information about which queries were not found")
    public static final Setting<Boolean> kill_query_verbose = Settings.setting("dbms.procedures.kill_query_verbose", Settings.BOOLEAN, "true");
    @Description(value="Whether or not to release the exclusive schema lock is while building uniqueness constraints index")
    @Internal
    public static final Setting<Boolean> release_schema_lock_while_building_constraint = Settings.setting("unsupported.dbms.schema.release_lock_while_building_constraint", Settings.BOOLEAN, "false");
    @Description(value="A list of procedures (comma separated) that are to be loaded. The list may contain both fully-qualified procedure names, and partial names with the wildcard '*'. If this setting is left empty no procedures will be loaded.")
    public static final Setting<String> procedure_whitelist = Settings.setting("dbms.security.procedures.whitelist", Settings.STRING, "*");
    @Description(value="Default network interface to listen for incoming connections. To listen for connections on all interfaces, use \"0.0.0.0\". To bind specific connectors to a specific network interfaces, specify the +listen_address+ properties for the specific connector.")
    public static final Setting<String> default_listen_address = Settings.setting("dbms.connectors.default_listen_address", Settings.STRING, "127.0.0.1");
    @Description(value="Default hostname or IP address the server uses to advertise itself to its connectors. To advertise a specific hostname or IP address for a specific connector, specify the +advertised_address+ property for the specific connector.")
    public static final Setting<String> default_advertised_address = Settings.setting("dbms.connectors.default_advertised_address", Settings.STRING, "localhost");
    @Internal
    public static final Setting<Boolean> bolt_logging_enabled = Settings.setting("unsupported.dbms.logs.bolt.enabled", Settings.BOOLEAN, "false");
    @Internal
    public static final Setting<File> bolt_log_filename = Settings.derivedSetting("unsupported.dbms.logs.bolt.path", logs_directory, logsDir -> new File((File)logsDir, "bolt.log"), Settings.PATH);
    @Description(value="Whether to apply network level write throttling")
    @Internal
    public static final Setting<Boolean> bolt_write_throttle = Settings.setting("unsupported.dbms.bolt.write_throttle", Settings.BOOLEAN, "true");
    @Description(value="When the size (in bytes) of write buffers, used by bolt's network layer, grows beyond this value bolt channel will advertise itself as unwritable and bolt worker threads will block until it becomes writable again.")
    @Internal
    public static final Setting<Integer> bolt_write_buffer_high_water_mark = Settings.buildSetting("unsupported.dbms.bolt.write_throttle.high_watermark", Settings.INTEGER, String.valueOf(ByteUnit.kibiBytes((long)512L))).constraint(Settings.range((int)ByteUnit.kibiBytes((long)64L), Integer.MAX_VALUE)).build();
    @Description(value="When the size (in bytes) of write buffers, previously advertised as unwritable, gets below this value bolt channel will re-advertise itself as writable and blocked bolt worker threads will resume execution.")
    @Internal
    public static final Setting<Integer> bolt_write_buffer_low_water_mark = Settings.buildSetting("unsupported.dbms.bolt.write_throttle.low_watermark", Settings.INTEGER, String.valueOf(ByteUnit.kibiBytes((long)128L))).constraint(Settings.range((int)ByteUnit.kibiBytes((long)16L), Integer.MAX_VALUE)).build();
    @Description(value="When the total time write throttle lock is held exceeds this value, the corresponding bolt channel will be aborted. Setting  this to 0 will disable this behaviour.")
    @Internal
    public static final Setting<Duration> bolt_write_throttle_max_duration = Settings.buildSetting("unsupported.dbms.bolt.write_throttle.max_duration", Settings.DURATION, "15m").constraint(Settings.min(Duration.ofSeconds(30L))).build();
    @Description(value="Create an archive of an index before re-creating it if failing to load on startup.")
    @Internal
    public static final Setting<Boolean> archive_failed_index = Settings.setting("unsupported.dbms.index.archive_failed", Settings.BOOLEAN, "false");
    public static final BoltConnectorValidator boltValidator = new BoltConnectorValidator();
    public static final SslPolicyConfigValidator sslPolicyConfigValidator = new SslPolicyConfigValidator();
    @Description(value="The maximum amount of time to wait for the database state represented by the bookmark.")
    public static final Setting<Duration> bookmark_ready_timeout = Settings.buildSetting("dbms.transaction.bookmark_ready_timeout", Settings.DURATION, "30s").constraint(Settings.min(Duration.ofSeconds(1L))).build();
    @Internal
    @Description(value="[Experimental] Defines whether memory for transaction state should allocaten on- or off-heap.")
    public static final Setting<TransactionStateMemoryAllocation> tx_state_memory_allocation = Settings.buildSetting("unsupported.dbms.tx_state.memory_allocation", Settings.options(TransactionStateMemoryAllocation.class, true), TransactionStateMemoryAllocation.ON_HEAP.name()).build();
    public static final HttpConnectorValidator httpValidator = new HttpConnectorValidator();

    @Deprecated
    public static BoltConnector boltConnector(String key) {
        return new BoltConnector(key);
    }

    @Deprecated
    @Description(value="Configuration options for Bolt connectors. \"(bolt-connector-key)\" is a placeholder for a unique name for the connector, for instance \"bolt-public\" or some other name that describes what the connector is for.")
    public static class BoltConnector
    extends Connector {
        @Description(value="Encryption level to require this connector to use")
        public final Setting<EncryptionLevel> encryption_level;
        @Description(value="Address the connector should bind to. This setting is deprecated and will be replaced by `+listen_address+`")
        public final Setting<ListenSocketAddress> address;
        @Description(value="Address the connector should bind to")
        public final Setting<ListenSocketAddress> listen_address;
        @Description(value="Advertised address for this connector")
        public final Setting<AdvertisedSocketAddress> advertised_address;

        public BoltConnector() {
            this("(bolt-connector-key)");
        }

        public BoltConnector(String key) {
            super(key, null);
            this.encryption_level = this.group.scope(Settings.setting("tls_level", Settings.options(EncryptionLevel.class), EncryptionLevel.OPTIONAL.name()));
            BaseSetting<ListenSocketAddress> legacyAddressSetting = Settings.listenAddress("address", 7687);
            Setting<ListenSocketAddress> listenAddressSetting = Settings.legacyFallback(legacyAddressSetting, Settings.listenAddress("listen_address", 7687));
            this.address = this.group.scope(legacyAddressSetting);
            this.listen_address = this.group.scope(listenAddressSetting);
            this.advertised_address = this.group.scope(Settings.advertisedAddress("advertised_address", listenAddressSetting));
        }

        public static enum EncryptionLevel {
            REQUIRED,
            OPTIONAL,
            DISABLED;

        }
    }

    @Group(value="dbms.connector")
    public static class Connector {
        @Description(value="Enable this connector")
        public final Setting<Boolean> enabled;
        @Description(value="Connector type. You should always set this to the connector type you want")
        public final Setting<ConnectorType> type;
        public final GroupSettingSupport group;

        public Connector(String key, String typeDefault) {
            this.group = new GroupSettingSupport(Connector.class, key);
            this.enabled = this.group.scope(Settings.setting("enabled", Settings.BOOLEAN, "false"));
            this.type = this.group.scope(Settings.setting("type", Settings.options(ConnectorType.class), Settings.NO_DEFAULT));
        }

        public String key() {
            return this.group.groupKey;
        }

        public static enum ConnectorType {
            BOLT,
            HTTP;

        }
    }

    public static enum TransactionStateMemoryAllocation {
        ON_HEAP,
        OFF_HEAP;

    }

    @Deprecated
    public static enum LabelIndex {
        NATIVE,
        LUCENE,
        AUTO;

    }

    public static enum SchemaIndex {
        NATIVE20("lucene+native-2.0"),
        NATIVE10("lucene+native-1.0"),
        LUCENE10("lucene-1.0");

        private final String param;

        private SchemaIndex(String param) {
            this.param = param;
        }

        public String param() {
            return this.param;
        }
    }
}

