/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.DefaultNonUniqueIndexSampler;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.UniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.SamplingUtil;
import org.neo4j.kernel.impl.index.schema.SpatialCRSSchemaIndex;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.SpatialFusionIndexUpdater;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;

class SpatialFusionIndexPopulator
implements IndexPopulator {
    private final long indexId;
    private final SchemaIndexDescriptor descriptor;
    private final SpatialCRSSchemaIndex.Supplier indexSupplier;
    private final Map<CoordinateReferenceSystem, SpatialCRSSchemaIndex> indexMap;
    private final IndexSamplerWrapper sampler;

    SpatialFusionIndexPopulator(Map<CoordinateReferenceSystem, SpatialCRSSchemaIndex> indexMap, long indexId, SchemaIndexDescriptor descriptor, IndexSamplingConfig samplingConfig, SpatialCRSSchemaIndex.Supplier indexSupplier) {
        this.indexMap = indexMap;
        this.indexId = indexId;
        this.descriptor = descriptor;
        this.indexSupplier = indexSupplier;
        this.sampler = new IndexSamplerWrapper(descriptor, samplingConfig);
    }

    @Override
    public void create() throws IOException {
        if (!this.indexMap.isEmpty()) {
            throw new IOException("Trying to create a new spatial populator when the index had already been created.");
        }
    }

    @Override
    public void drop() throws IOException {
        FusionIndexBase.forAll(SpatialCRSSchemaIndex::drop, this.indexMap.values());
        this.indexMap.clear();
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate<?>> updates) throws IndexEntryConflictException, IOException {
        HashMap batchMap = new HashMap();
        for (IndexEntryUpdate<?> update : updates) {
            this.selectUpdates(batchMap, update.values()).add(update);
        }
        for (CoordinateReferenceSystem crs : batchMap.keySet()) {
            SpatialCRSSchemaIndex index = this.indexSupplier.get(this.descriptor, this.indexMap, this.indexId, crs);
            index.startPopulation();
            index.add((Collection)batchMap.get(crs));
        }
    }

    private Collection<IndexEntryUpdate<?>> selectUpdates(Map<CoordinateReferenceSystem, Collection<IndexEntryUpdate<?>>> instances, Value ... values) {
        assert (values.length == 1);
        PointValue pointValue = (PointValue)values[0];
        return instances.computeIfAbsent(pointValue.getCoordinateReferenceSystem(), k -> new ArrayList());
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) throws IndexEntryConflictException, IOException {
    }

    @Override
    public IndexUpdater newPopulatingUpdater(PropertyAccessor accessor) {
        return SpatialFusionIndexUpdater.updaterForPopulator(this.indexMap, this.indexId, this.indexSupplier, this.descriptor);
    }

    @Override
    public void close(boolean populationCompletedSuccessfully) throws IOException {
        FusionIndexBase.forAll(spatialKnownIndex -> spatialKnownIndex.finishPopulation(populationCompletedSuccessfully), this.indexMap.values());
    }

    @Override
    public void markAsFailed(String failure) {
        FusionIndexBase.forAll(spatialKnownIndex -> spatialKnownIndex.markAsFailed(failure), this.indexMap.values());
    }

    @Override
    public void includeSample(IndexEntryUpdate<?> update) {
        this.sampler.includeSample(update.values());
    }

    @Override
    public IndexSample sampleResult() {
        return this.sampler.sampleResult();
    }

    private static class IndexSamplerWrapper {
        private final DefaultNonUniqueIndexSampler generalSampler;
        private final UniqueIndexSampler uniqueSampler;

        IndexSamplerWrapper(SchemaIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
            switch (descriptor.type()) {
                case GENERAL: {
                    this.generalSampler = new DefaultNonUniqueIndexSampler(samplingConfig.sampleSizeLimit());
                    this.uniqueSampler = null;
                    break;
                }
                case UNIQUE: {
                    this.generalSampler = null;
                    this.uniqueSampler = new UniqueIndexSampler();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unexpected index type " + (Object)((Object)descriptor.type()));
                }
            }
        }

        void includeSample(Value[] values) {
            if (this.uniqueSampler != null) {
                this.uniqueSampler.increment(1L);
            } else {
                this.generalSampler.include(SamplingUtil.encodedStringValuesForSampling(values));
            }
        }

        IndexSample sampleResult() {
            if (this.uniqueSampler != null) {
                return this.uniqueSampler.result();
            }
            return this.generalSampler.result();
        }
    }
}

