/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.lang.reflect.Array;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;

public abstract class FusionIndexBase<T> {
    private static final int INSTANCE_COUNT = 5;
    static final int STRING = 0;
    static final int NUMBER = 1;
    static final int SPATIAL = 2;
    static final int TEMPORAL = 3;
    static final int LUCENE = 4;
    final T[] instances;
    final FusionIndexProvider.Selector selector;

    FusionIndexBase(T[] instances, FusionIndexProvider.Selector selector) {
        assert (instances.length == 5);
        this.instances = instances;
        this.selector = selector;
    }

    <R, E extends Exception> R[] instancesAs(Class<R> cls, ThrowingFunction<T, R, E> converter) throws E {
        return FusionIndexBase.instancesAs(this.instances, cls, converter);
    }

    static <T, R, E extends Exception> R[] instancesAs(T[] instances, Class<R> cls, ThrowingFunction<T, R, E> converter) throws E {
        Object[] result = (Object[])Array.newInstance(cls, instances.length);
        for (int i = 0; i < instances.length; ++i) {
            result[i] = converter.apply(instances[i]);
        }
        return result;
    }

    @SafeVarargs
    public static <T, E extends Exception> void forAll(ThrowingConsumer<T, E> consumer, T ... subjects) throws E {
        Exception exception = null;
        for (T subject : subjects) {
            try {
                consumer.accept(subject);
            }
            catch (Throwable t) {
                Exception e = (Exception)t;
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static <T, E extends Exception> void forAll(ThrowingConsumer<T, E> consumer, Iterable<T> subjects) throws E {
        Exception exception = null;
        for (T subject : subjects) {
            try {
                consumer.accept(subject);
            }
            catch (Throwable t) {
                Exception e = (Exception)t;
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

