/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.TemporalIndexAccessor;
import org.neo4j.kernel.impl.index.schema.TemporalIndexCache;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;

public class TemporalIndexUpdater
extends TemporalIndexCache<NativeSchemaIndexUpdater<?, NativeSchemaValue>, IOException>
implements IndexUpdater {
    TemporalIndexUpdater(TemporalIndexAccessor accessor, IndexUpdateMode mode) {
        super(new PartFactory(accessor, mode));
    }

    @Override
    public void process(IndexEntryUpdate<?> update) throws IOException, IndexEntryConflictException {
        IndexUpdater to = (IndexUpdater)this.select(update.values()[0].valueGroup());
        switch (update.updateMode()) {
            case ADDED: 
            case REMOVED: {
                to.process(update);
                break;
            }
            case CHANGED: {
                IndexUpdater from = (IndexUpdater)this.select(update.beforeValues()[0].valueGroup());
                if (from == to) {
                    from.process(update);
                    break;
                }
                from.process(IndexEntryUpdate.remove(update.getEntityId(), update.indexKey(), update.beforeValues()));
                to.process(IndexEntryUpdate.add(update.getEntityId(), update.indexKey(), update.values()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown update mode");
            }
        }
    }

    @Override
    public void close() throws IOException {
        FusionIndexBase.forAll(NativeSchemaIndexUpdater::close, this);
    }

    static class PartFactory
    implements TemporalIndexCache.Factory<NativeSchemaIndexUpdater<?, NativeSchemaValue>, IOException> {
        private final TemporalIndexAccessor accessor;
        private final IndexUpdateMode mode;

        PartFactory(TemporalIndexAccessor accessor, IndexUpdateMode mode) {
            this.accessor = accessor;
            this.mode = mode;
        }

        @Override
        public NativeSchemaIndexUpdater<?, NativeSchemaValue> newDate() throws IOException {
            return ((TemporalIndexAccessor.PartAccessor)this.accessor.date()).newUpdater(this.mode);
        }

        @Override
        public NativeSchemaIndexUpdater<?, NativeSchemaValue> newLocalDateTime() throws IOException {
            return ((TemporalIndexAccessor.PartAccessor)this.accessor.localDateTime()).newUpdater(this.mode);
        }

        @Override
        public NativeSchemaIndexUpdater<?, NativeSchemaValue> newZonedDateTime() throws IOException {
            return ((TemporalIndexAccessor.PartAccessor)this.accessor.zonedDateTime()).newUpdater(this.mode);
        }

        @Override
        public NativeSchemaIndexUpdater<?, NativeSchemaValue> newLocalTime() throws IOException {
            return ((TemporalIndexAccessor.PartAccessor)this.accessor.localTime()).newUpdater(this.mode);
        }

        @Override
        public NativeSchemaIndexUpdater<?, NativeSchemaValue> newZonedTime() throws IOException {
            return ((TemporalIndexAccessor.PartAccessor)this.accessor.zonedTime()).newUpdater(this.mode);
        }

        @Override
        public NativeSchemaIndexUpdater<?, NativeSchemaValue> newDuration() throws IOException {
            return ((TemporalIndexAccessor.PartAccessor)this.accessor.duration()).newUpdater(this.mode);
        }
    }
}

