/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexes;
import org.neo4j.kernel.impl.index.schema.TemporalIndexAccessor;
import org.neo4j.kernel.impl.index.schema.TemporalIndexFiles;
import org.neo4j.kernel.impl.index.schema.TemporalIndexPopulator;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;

public class TemporalIndexProvider
extends IndexProvider {
    public static final String KEY = "temporal";
    public static final IndexProvider.Descriptor TEMPORAL_PROVIDER_DESCRIPTOR = new IndexProvider.Descriptor("temporal", "1.0");
    private final PageCache pageCache;
    private final FileSystemAbstraction fs;
    private final IndexProvider.Monitor monitor;
    private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    private final boolean readOnly;

    public TemporalIndexProvider(PageCache pageCache, FileSystemAbstraction fs, IndexDirectoryStructure.Factory directoryStructure, IndexProvider.Monitor monitor, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly) {
        super(TEMPORAL_PROVIDER_DESCRIPTOR, 0, directoryStructure);
        this.pageCache = pageCache;
        this.fs = fs;
        this.monitor = monitor;
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        this.readOnly = readOnly;
    }

    @Override
    public IndexPopulator getPopulator(long indexId, SchemaIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Can't create populator for read only index");
        }
        TemporalIndexFiles files = new TemporalIndexFiles(this.directoryStructure(), indexId, descriptor, this.fs);
        return new TemporalIndexPopulator(indexId, descriptor, samplingConfig, files, this.pageCache, this.fs, this.monitor);
    }

    @Override
    public IndexAccessor getOnlineAccessor(long indexId, SchemaIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        TemporalIndexFiles files = new TemporalIndexFiles(this.directoryStructure(), indexId, descriptor, this.fs);
        return new TemporalIndexAccessor(indexId, descriptor, samplingConfig, this.pageCache, this.fs, this.recoveryCleanupWorkCollector, this.monitor, files);
    }

    @Override
    public String getPopulationFailure(long indexId, SchemaIndexDescriptor descriptor) throws IllegalStateException {
        TemporalIndexFiles temporalIndexFiles = new TemporalIndexFiles(this.directoryStructure(), indexId, descriptor, this.fs);
        try {
            for (TemporalIndexFiles.FileLayout subIndex : temporalIndexFiles.existing()) {
                String indexFailure = NativeSchemaIndexes.readFailureMessage(this.pageCache, subIndex.indexFile, subIndex.layout);
                if (indexFailure == null) continue;
                return indexFailure;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throw new IllegalStateException("Index " + indexId + " isn't failed");
    }

    @Override
    public InternalIndexState getInitialState(long indexId, SchemaIndexDescriptor descriptor) {
        TemporalIndexFiles temporalIndexFiles = new TemporalIndexFiles(this.directoryStructure(), indexId, descriptor, this.fs);
        InternalIndexState state = InternalIndexState.ONLINE;
        for (TemporalIndexFiles.FileLayout subIndex : temporalIndexFiles.existing()) {
            try {
                switch (NativeSchemaIndexes.readState(this.pageCache, subIndex.indexFile, subIndex.layout)) {
                    case FAILED: {
                        return InternalIndexState.FAILED;
                    }
                    case POPULATING: {
                        state = InternalIndexState.POPULATING;
                    }
                }
            }
            catch (IOException e) {
                this.monitor.failedToOpenIndex(indexId, descriptor, "Requesting re-population.", e);
                return InternalIndexState.POPULATING;
            }
        }
        return state;
    }

    @Override
    public IndexCapability getCapability(SchemaIndexDescriptor schemaIndexDescriptor) {
        return IndexCapability.NO_CAPABILITY;
    }

    @Override
    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
        return StoreMigrationParticipant.NOT_PARTICIPATING;
    }
}

