/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.DefaultNonUniqueIndexSampler;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.UniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.SamplingUtil;
import org.neo4j.kernel.impl.index.schema.TemporalIndexCache;
import org.neo4j.kernel.impl.index.schema.TemporalIndexFiles;
import org.neo4j.kernel.impl.index.schema.TemporalIndexPartReader;
import org.neo4j.kernel.impl.index.schema.TemporalIndexPopulatingUpdater;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.values.storable.Value;

class TemporalIndexPopulator
extends TemporalIndexCache<PartPopulator<?>, IOException>
implements IndexPopulator {
    private final IndexSamplerWrapper sampler;

    TemporalIndexPopulator(long indexId, SchemaIndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TemporalIndexFiles temporalIndexFiles, PageCache pageCache, FileSystemAbstraction fs, IndexProvider.Monitor monitor) {
        super(new PartFactory(pageCache, fs, temporalIndexFiles, indexId, descriptor, samplingConfig, monitor));
        this.sampler = new IndexSamplerWrapper(descriptor, samplingConfig);
    }

    @Override
    public synchronized void create() throws IOException {
        FusionIndexBase.forAll(NativeSchemaIndexPopulator::clear, this);
    }

    @Override
    public synchronized void drop() throws IOException {
        FusionIndexBase.forAll(NativeSchemaIndexPopulator::drop, this);
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate<?>> updates) throws IndexEntryConflictException, IOException {
        for (IndexEntryUpdate<?> update : updates) {
            ((PartPopulator)this.select(update.values()[0].valueGroup())).batchUpdate(update);
        }
        for (PartPopulator part : this) {
            part.applyUpdateBatch();
        }
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) throws IndexEntryConflictException, IOException {
    }

    @Override
    public IndexUpdater newPopulatingUpdater(PropertyAccessor accessor) {
        return new TemporalIndexPopulatingUpdater(this, accessor);
    }

    @Override
    public synchronized void close(boolean populationCompletedSuccessfully) throws IOException {
        for (NativeSchemaIndexPopulator part : this) {
            part.close(populationCompletedSuccessfully);
        }
    }

    @Override
    public synchronized void markAsFailed(String failure) {
        for (NativeSchemaIndexPopulator part : this) {
            part.markAsFailed(failure);
        }
    }

    @Override
    public void includeSample(IndexEntryUpdate<?> update) {
        this.sampler.includeSample(update.values());
    }

    @Override
    public IndexSample sampleResult() {
        return this.sampler.sampleResult();
    }

    static class PartFactory
    implements TemporalIndexCache.Factory<PartPopulator<?>, IOException> {
        private final PageCache pageCache;
        private final FileSystemAbstraction fs;
        private final TemporalIndexFiles temporalIndexFiles;
        private final long indexId;
        private final SchemaIndexDescriptor descriptor;
        private final IndexSamplingConfig samplingConfig;
        private final IndexProvider.Monitor monitor;

        PartFactory(PageCache pageCache, FileSystemAbstraction fs, TemporalIndexFiles temporalIndexFiles, long indexId, SchemaIndexDescriptor descriptor, IndexSamplingConfig samplingConfig, IndexProvider.Monitor monitor) {
            this.pageCache = pageCache;
            this.fs = fs;
            this.temporalIndexFiles = temporalIndexFiles;
            this.indexId = indexId;
            this.descriptor = descriptor;
            this.samplingConfig = samplingConfig;
            this.monitor = monitor;
        }

        @Override
        public PartPopulator<?> newDate() throws IOException {
            return this.create(this.temporalIndexFiles.date());
        }

        @Override
        public PartPopulator<?> newLocalDateTime() throws IOException {
            return this.create(this.temporalIndexFiles.localDateTime());
        }

        @Override
        public PartPopulator<?> newZonedDateTime() throws IOException {
            return this.create(this.temporalIndexFiles.zonedDateTime());
        }

        @Override
        public PartPopulator<?> newLocalTime() throws IOException {
            return this.create(this.temporalIndexFiles.localTime());
        }

        @Override
        public PartPopulator<?> newZonedTime() throws IOException {
            return this.create(this.temporalIndexFiles.zonedTime());
        }

        @Override
        public PartPopulator<?> newDuration() throws IOException {
            return this.create(this.temporalIndexFiles.duration());
        }

        private <KEY extends NativeSchemaKey> PartPopulator<KEY> create(TemporalIndexFiles.FileLayout<KEY> fileLayout) throws IOException {
            PartPopulator<KEY> populator = new PartPopulator<KEY>(this.pageCache, this.fs, fileLayout, this.monitor, this.descriptor, this.indexId, this.samplingConfig);
            populator.create();
            return populator;
        }
    }

    static class PartPopulator<KEY extends NativeSchemaKey>
    extends NativeSchemaIndexPopulator<KEY, NativeSchemaValue> {
        List<IndexEntryUpdate<?>> updates = new ArrayList();

        PartPopulator(PageCache pageCache, FileSystemAbstraction fs, TemporalIndexFiles.FileLayout<KEY> fileLayout, IndexProvider.Monitor monitor, SchemaIndexDescriptor descriptor, long indexId, IndexSamplingConfig samplingConfig) {
            super(pageCache, fs, fileLayout.indexFile, fileLayout.layout, monitor, descriptor, indexId, samplingConfig);
        }

        void batchUpdate(IndexEntryUpdate<?> update) {
            this.updates.add(update);
        }

        void applyUpdateBatch() throws IOException, IndexEntryConflictException {
            try {
                this.add(this.updates);
            }
            finally {
                this.updates = new ArrayList();
            }
        }

        @Override
        IndexReader newReader() {
            return new TemporalIndexPartReader(this.tree, this.layout, this.samplingConfig, this.descriptor);
        }

        @Override
        public void includeSample(IndexEntryUpdate<?> update) {
            throw new UnsupportedOperationException("please to not get here!");
        }

        @Override
        public IndexSample sampleResult() {
            throw new UnsupportedOperationException("this sampling code needs a rewrite.");
        }
    }

    private static class IndexSamplerWrapper {
        private final DefaultNonUniqueIndexSampler generalSampler;
        private final UniqueIndexSampler uniqueSampler;

        IndexSamplerWrapper(SchemaIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
            switch (descriptor.type()) {
                case GENERAL: {
                    this.generalSampler = new DefaultNonUniqueIndexSampler(samplingConfig.sampleSizeLimit());
                    this.uniqueSampler = null;
                    break;
                }
                case UNIQUE: {
                    this.generalSampler = null;
                    this.uniqueSampler = new UniqueIndexSampler();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unexpected index type " + (Object)((Object)descriptor.type()));
                }
            }
        }

        void includeSample(Value[] values) {
            if (this.uniqueSampler != null) {
                this.uniqueSampler.increment(1L);
            } else {
                this.generalSampler.include(SamplingUtil.encodedStringValuesForSampling(values));
            }
        }

        IndexSample sampleResult() {
            if (this.uniqueSampler != null) {
                return this.uniqueSampler.result();
            }
            return this.generalSampler.result();
        }
    }
}

