/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexValueCapability;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.NativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.StringLayout;
import org.neo4j.kernel.impl.index.schema.StringSchemaIndexAccessor;
import org.neo4j.kernel.impl.index.schema.StringSchemaIndexPopulator;
import org.neo4j.kernel.impl.index.schema.StringSchemaKey;
import org.neo4j.values.storable.ValueGroup;

public class StringIndexProvider
extends NativeIndexProvider<StringSchemaKey, NativeSchemaValue> {
    public static final String KEY = "string";
    static final IndexCapability CAPABILITY = new StringIndexCapability();
    private static final IndexProvider.Descriptor STRING_PROVIDER_DESCRIPTOR = new IndexProvider.Descriptor("string", "1.0");

    public StringIndexProvider(PageCache pageCache, FileSystemAbstraction fs, IndexDirectoryStructure.Factory directoryStructure, IndexProvider.Monitor monitor, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly) {
        super(STRING_PROVIDER_DESCRIPTOR, 0, directoryStructure, pageCache, fs, monitor, recoveryCleanupWorkCollector, readOnly);
    }

    @Override
    Layout<StringSchemaKey, NativeSchemaValue> layout(SchemaIndexDescriptor descriptor) {
        return new StringLayout();
    }

    @Override
    protected IndexPopulator newIndexPopulator(File storeFile, Layout<StringSchemaKey, NativeSchemaValue> layout, SchemaIndexDescriptor descriptor, long indexId, IndexSamplingConfig samplingConfig) {
        return new StringSchemaIndexPopulator(this.pageCache, this.fs, storeFile, layout, this.monitor, descriptor, indexId, samplingConfig);
    }

    @Override
    protected IndexAccessor newIndexAccessor(File storeFile, Layout<StringSchemaKey, NativeSchemaValue> layout, SchemaIndexDescriptor descriptor, long indexId, IndexSamplingConfig samplingConfig) throws IOException {
        return new StringSchemaIndexAccessor(this.pageCache, this.fs, storeFile, layout, this.recoveryCleanupWorkCollector, this.monitor, descriptor, indexId, samplingConfig);
    }

    @Override
    public IndexCapability getCapability(SchemaIndexDescriptor schemaIndexDescriptor) {
        return CAPABILITY;
    }

    private static class StringIndexCapability
    implements IndexCapability {
        private static final IndexOrder[] SUPPORTED_ORDER = new IndexOrder[]{IndexOrder.ASCENDING};
        private static final IndexOrder[] EMPTY_ORDER = new IndexOrder[0];

        private StringIndexCapability() {
        }

        public IndexOrder[] orderCapability(ValueGroup ... valueGroups) {
            if (this.support(valueGroups)) {
                return SUPPORTED_ORDER;
            }
            return EMPTY_ORDER;
        }

        public IndexValueCapability valueCapability(ValueGroup ... valueGroups) {
            if (this.support(valueGroups)) {
                return IndexValueCapability.YES;
            }
            if (this.singleWildcard(valueGroups)) {
                return IndexValueCapability.PARTIAL;
            }
            return IndexValueCapability.NO;
        }

        private boolean singleWildcard(ValueGroup[] valueGroups) {
            return valueGroups.length == 1 && valueGroups[0] == ValueGroup.UNKNOWN;
        }

        private boolean support(ValueGroup[] valueGroups) {
            return valueGroups.length == 1 && valueGroups[0] == ValueGroup.TEXT;
        }
    }
}

