/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.InwardKernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.spi.explicitindex.IndexImplementation;

public class ExplicitIndexStore {
    private final IndexConfigStore indexStore;
    private final Config config;
    private final Function<String, IndexImplementation> indexProviders;
    private final Supplier<InwardKernel> kernel;

    public ExplicitIndexStore(@Nonnull Config config, IndexConfigStore indexStore, Supplier<InwardKernel> kernel, Function<String, IndexImplementation> indexProviders) {
        this.config = config;
        this.indexStore = indexStore;
        this.kernel = kernel;
        this.indexProviders = indexProviders;
    }

    public Map<String, String> getOrCreateNodeIndexConfig(String indexName, Map<String, String> customConfiguration) {
        return this.getOrCreateIndexConfig(IndexEntityType.Node, indexName, customConfiguration);
    }

    public Map<String, String> getOrCreateRelationshipIndexConfig(String indexName, Map<String, String> customConfiguration) {
        return this.getOrCreateIndexConfig(IndexEntityType.Relationship, indexName, customConfiguration);
    }

    private Map<String, String> findIndexConfig(Class<? extends PropertyContainer> cls, String indexName, Map<String, String> suppliedConfig, @Nonnull Config dbConfig) {
        String provider;
        Map<String, String> storedConfig = this.indexStore.get(cls, indexName);
        if (storedConfig != null && suppliedConfig == null) {
            Map<String, String> newConfig = this.injectDefaultProviderIfMissing(indexName, dbConfig, storedConfig);
            if (newConfig != storedConfig) {
                this.indexStore.set(cls, indexName, newConfig);
            }
            return newConfig;
        }
        Map<String, String> configToUse = suppliedConfig;
        if (configToUse == null) {
            provider = this.getDefaultProvider(indexName, dbConfig);
            configToUse = MapUtil.stringMap((String[])new String[]{"provider", provider});
        } else {
            provider = configToUse.get("provider");
            provider = provider == null ? this.getDefaultProvider(indexName, dbConfig) : provider;
        }
        IndexImplementation indexProvider = this.indexProviders.apply(provider);
        configToUse = indexProvider.fillInDefaults(configToUse);
        configToUse = this.injectDefaultProviderIfMissing(indexName, dbConfig, configToUse);
        if (storedConfig != null) {
            ExplicitIndexStore.assertConfigMatches(indexProvider, indexName, storedConfig, suppliedConfig);
            Map<String, String> newConfig = this.injectDefaultProviderIfMissing(indexName, dbConfig, storedConfig);
            if (newConfig != storedConfig) {
                this.indexStore.set(cls, indexName, newConfig);
            }
            configToUse = newConfig;
        }
        return Collections.unmodifiableMap(configToUse);
    }

    public static void assertConfigMatches(IndexImplementation indexProvider, String indexName, Map<String, String> storedConfig, Map<String, String> suppliedConfig) {
        if (suppliedConfig != null && !indexProvider.configMatches(storedConfig, suppliedConfig)) {
            throw new IllegalArgumentException("Supplied index configuration:\n" + suppliedConfig + "\ndoesn't match stored config in a valid way:\n" + storedConfig + "\nfor '" + indexName + "'");
        }
    }

    @Nonnull
    private Map<String, String> injectDefaultProviderIfMissing(@Nullable String indexName, @Nonnull Config dbConfig, @Nonnull Map<String, String> config) {
        String provider = config.get("provider");
        if (provider == null) {
            config = new HashMap<String, String>(config);
            config.put("provider", this.getDefaultProvider(indexName, dbConfig));
        }
        return config;
    }

    @Nonnull
    private String getDefaultProvider(@Nullable String indexName, @Nonnull Config dbConfig) {
        return dbConfig.getRaw("index." + indexName).orElseGet(() -> dbConfig.getRaw("index").orElse("lucene"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getOrCreateIndexConfig(IndexEntityType entityType, String indexName, Map<String, String> suppliedConfig) {
        Map<String, String> config = this.findIndexConfig(entityType.entityClass(), indexName, suppliedConfig, this.config);
        if (!this.indexStore.has(entityType.entityClass(), indexName)) {
            ExplicitIndexStore explicitIndexStore = this;
            synchronized (explicitIndexStore) {
                Map<String, String> existing = this.indexStore.get(entityType.entityClass(), indexName);
                if (existing != null) {
                    ExplicitIndexStore.assertConfigMatches(this.indexProviders.apply(existing.get("provider")), indexName, existing, config);
                    return config;
                }
                try (KernelTransaction transaction = this.kernel.get().newTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED);
                     Statement statement = transaction.acquireStatement();){
                    switch (entityType) {
                        case Node: {
                            statement.dataWriteOperations().nodeExplicitIndexCreate(indexName, config);
                            break;
                        }
                        case Relationship: {
                            statement.dataWriteOperations().relationshipExplicitIndexCreate(indexName, config);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown entity type: " + (Object)((Object)entityType));
                        }
                    }
                    transaction.success();
                }
                catch (Exception ex) {
                    throw new TransactionFailureException("Index creation failed for " + indexName + ", " + config, (Throwable)ex);
                }
            }
        }
        return config;
    }

    public String setNodeIndexConfiguration(String indexName, String key, String value) throws ExplicitIndexNotFoundKernelException {
        this.assertLegalConfigKey(key);
        HashMap<String, String> config = new HashMap<String, String>(this.getNodeIndexConfiguration(indexName));
        String oldValue = config.put(key, value);
        this.indexStore.set(Node.class, indexName, config);
        return oldValue;
    }

    public String setRelationshipIndexConfiguration(String indexName, String key, String value) throws ExplicitIndexNotFoundKernelException {
        this.assertLegalConfigKey(key);
        HashMap<String, String> config = new HashMap<String, String>(this.getRelationshipIndexConfiguration(indexName));
        String oldValue = config.put(key, value);
        this.indexStore.set(Relationship.class, indexName, config);
        return oldValue;
    }

    public String removeNodeIndexConfiguration(String indexName, String key) throws ExplicitIndexNotFoundKernelException {
        this.assertLegalConfigKey(key);
        HashMap<String, String> config = new HashMap<String, String>(this.getNodeIndexConfiguration(indexName));
        String value = (String)config.remove(key);
        if (value != null) {
            this.indexStore.set(Node.class, indexName, config);
        }
        return value;
    }

    public String removeRelationshipIndexConfiguration(String indexName, String key) throws ExplicitIndexNotFoundKernelException {
        this.assertLegalConfigKey(key);
        HashMap<String, String> config = new HashMap<String, String>(this.getRelationshipIndexConfiguration(indexName));
        String value = (String)config.remove(key);
        if (value != null) {
            this.indexStore.set(Relationship.class, indexName, config);
        }
        return value;
    }

    public Map<String, String> getNodeIndexConfiguration(String indexName) throws ExplicitIndexNotFoundKernelException {
        Map<String, String> config = this.indexStore.get(Node.class, indexName);
        if (config == null) {
            throw new ExplicitIndexNotFoundKernelException("No node index '" + indexName + "' found", new Object[0]);
        }
        return config;
    }

    public Map<String, String> getRelationshipIndexConfiguration(String indexName) throws ExplicitIndexNotFoundKernelException {
        Map<String, String> config = this.indexStore.get(Relationship.class, indexName);
        if (config == null) {
            throw new ExplicitIndexNotFoundKernelException("No relationship index '" + indexName + "' found", new Object[0]);
        }
        return config;
    }

    private void assertLegalConfigKey(String key) {
        if (key.equals("provider")) {
            throw new IllegalArgumentException("'" + key + "' cannot be modified");
        }
    }

    public String[] getAllNodeIndexNames() {
        return this.indexStore.getNames(Node.class);
    }

    public String[] getAllRelationshipIndexNames() {
        return this.indexStore.getNames(Relationship.class);
    }
}

