/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Map;
import org.neo4j.kernel.impl.util.VersionedHashMap;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.kernel.impl.util.diffsets.PrimitiveLongDiffSets;
import org.neo4j.storageengine.api.txstate.PrimitiveLongReadableDiffSets;

public class PropertyChanges {
    private final CollectionsFactory collectionsFactory;
    private VersionedHashMap<Integer, Map<Object, PrimitiveLongDiffSets>> changes;

    public PropertyChanges(CollectionsFactory collectionsFactory) {
        this.collectionsFactory = collectionsFactory;
    }

    public PrimitiveLongReadableDiffSets changesForProperty(int propertyKeyId, Object value) {
        PrimitiveLongDiffSets valueChanges;
        Map<Object, PrimitiveLongDiffSets> keyChanges;
        if (this.changes != null && (keyChanges = this.changes.get(propertyKeyId)) != null && (valueChanges = keyChanges.get(value)) != null) {
            return valueChanges;
        }
        return PrimitiveLongReadableDiffSets.EMPTY;
    }

    public void changeProperty(long entityId, int propertyKeyId, Object oldValue, Object newValue) {
        Map<Object, PrimitiveLongDiffSets> keyChanges = this.keyChanges(propertyKeyId);
        this.valueChanges(newValue, keyChanges).add(entityId);
        this.valueChanges(oldValue, keyChanges).remove(entityId);
    }

    public void addProperty(long entityId, int propertyKeyId, Object value) {
        this.valueChanges(value, this.keyChanges(propertyKeyId)).add(entityId);
    }

    public void removeProperty(long entityId, int propertyKeyId, Object oldValue) {
        this.valueChanges(oldValue, this.keyChanges(propertyKeyId)).remove(entityId);
    }

    private Map<Object, PrimitiveLongDiffSets> keyChanges(int propertyKeyId) {
        if (this.changes == null) {
            this.changes = new VersionedHashMap();
        }
        return this.changes.computeIfAbsent(propertyKeyId, k -> new VersionedHashMap());
    }

    private PrimitiveLongDiffSets valueChanges(Object newValue, Map<Object, PrimitiveLongDiffSets> keyChanges) {
        return keyChanges.computeIfAbsent(newValue, k -> this.collectionsFactory.newLongDiffSets());
    }

    public void release() {
        for (Map<Object, PrimitiveLongDiffSets> map : this.changes.values()) {
            map.values().forEach(PrimitiveLongDiffSets::close);
        }
    }
}

