/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Arrays;
import org.neo4j.internal.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.IndexBelongsToConstraintException;
import org.neo4j.kernel.api.exceptions.schema.NoSuchConstraintException;
import org.neo4j.kernel.api.exceptions.schema.NoSuchIndexException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedPropertyInCompositeSchemaException;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.NodeExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.NodeKeyConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.RelExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.SchemaIndexDescriptor;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.operations.KeyWriteOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;

public class DataIntegrityValidatingStatementOperations
implements KeyWriteOperations,
SchemaWriteOperations {
    private final KeyWriteOperations keyWriteDelegate;
    private final SchemaReadOperations schemaReadDelegate;
    private final SchemaWriteOperations schemaWriteDelegate;

    public DataIntegrityValidatingStatementOperations(KeyWriteOperations keyWriteDelegate, SchemaReadOperations schemaReadDelegate, SchemaWriteOperations schemaWriteDelegate) {
        this.keyWriteDelegate = keyWriteDelegate;
        this.schemaReadDelegate = schemaReadDelegate;
        this.schemaWriteDelegate = schemaWriteDelegate;
    }

    @Override
    public int propertyKeyGetOrCreateForName(Statement state, String propertyKey) throws IllegalTokenNameException {
        return this.keyWriteDelegate.propertyKeyGetOrCreateForName(state, this.checkValidTokenName(propertyKey));
    }

    @Override
    public int relationshipTypeGetOrCreateForName(Statement state, String relationshipTypeName) throws IllegalTokenNameException {
        return this.keyWriteDelegate.relationshipTypeGetOrCreateForName(state, this.checkValidTokenName(relationshipTypeName));
    }

    @Override
    public int labelGetOrCreateForName(Statement state, String label) throws IllegalTokenNameException, TooManyLabelsException {
        return this.keyWriteDelegate.labelGetOrCreateForName(state, this.checkValidTokenName(label));
    }

    @Override
    public void labelCreateForName(KernelStatement state, String labelName, int id) throws IllegalTokenNameException, TooManyLabelsException {
        this.keyWriteDelegate.labelCreateForName(state, labelName, id);
    }

    @Override
    public void propertyKeyCreateForName(KernelStatement state, String propertyKeyName, int id) throws IllegalTokenNameException {
        this.keyWriteDelegate.propertyKeyCreateForName(state, propertyKeyName, id);
    }

    @Override
    public void relationshipTypeCreateForName(KernelStatement state, String relationshipTypeName, int id) throws IllegalTokenNameException {
        this.keyWriteDelegate.relationshipTypeCreateForName(state, relationshipTypeName, id);
    }

    @Override
    public SchemaIndexDescriptor indexCreate(KernelStatement state, LabelSchemaDescriptor descriptor) throws AlreadyIndexedException, AlreadyConstrainedException, RepeatedPropertyInCompositeSchemaException {
        this.assertValidDescriptor((SchemaDescriptor)descriptor, SchemaKernelException.OperationContext.INDEX_CREATION);
        this.assertIndexDoesNotExist(state, SchemaKernelException.OperationContext.INDEX_CREATION, descriptor);
        return this.schemaWriteDelegate.indexCreate(state, descriptor);
    }

    @Override
    public void indexDrop(KernelStatement state, SchemaIndexDescriptor index) throws DropIndexFailureException {
        try {
            SchemaIndexDescriptor existingIndex = this.schemaReadDelegate.indexGetForSchema(state, index.schema());
            if (existingIndex == null) {
                throw new NoSuchIndexException(index.schema());
            }
            if (existingIndex.type() == SchemaIndexDescriptor.Type.UNIQUE && this.schemaReadDelegate.indexGetOwningUniquenessConstraintId(state, existingIndex) != null) {
                throw new IndexBelongsToConstraintException(index.schema());
            }
        }
        catch (IndexBelongsToConstraintException | NoSuchIndexException e) {
            throw new DropIndexFailureException(index.schema(), e);
        }
        this.schemaWriteDelegate.indexDrop(state, index);
    }

    @Override
    public void uniqueIndexDrop(KernelStatement state, SchemaIndexDescriptor index) throws DropIndexFailureException {
        this.schemaWriteDelegate.uniqueIndexDrop(state, index);
    }

    @Override
    public NodeKeyConstraintDescriptor nodeKeyConstraintCreate(KernelStatement state, LabelSchemaDescriptor descriptor) throws AlreadyConstrainedException, CreateConstraintFailureException, AlreadyIndexedException, RepeatedPropertyInCompositeSchemaException {
        this.assertValidDescriptor((SchemaDescriptor)descriptor, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
        NodeKeyConstraintDescriptor constraint = ConstraintDescriptorFactory.nodeKeyForSchema((SchemaDescriptor)descriptor);
        this.assertConstraintDoesNotExist(state, constraint);
        this.assertIndexDoesNotExist(state, SchemaKernelException.OperationContext.CONSTRAINT_CREATION, descriptor);
        return this.schemaWriteDelegate.nodeKeyConstraintCreate(state, descriptor);
    }

    @Override
    public UniquenessConstraintDescriptor uniquePropertyConstraintCreate(KernelStatement state, LabelSchemaDescriptor descriptor) throws AlreadyConstrainedException, CreateConstraintFailureException, AlreadyIndexedException, RepeatedPropertyInCompositeSchemaException {
        this.assertValidDescriptor((SchemaDescriptor)descriptor, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)descriptor);
        this.assertConstraintDoesNotExist(state, constraint);
        this.assertIndexDoesNotExist(state, SchemaKernelException.OperationContext.CONSTRAINT_CREATION, descriptor);
        return this.schemaWriteDelegate.uniquePropertyConstraintCreate(state, descriptor);
    }

    @Override
    public NodeExistenceConstraintDescriptor nodePropertyExistenceConstraintCreate(KernelStatement state, LabelSchemaDescriptor descriptor) throws AlreadyConstrainedException, CreateConstraintFailureException, RepeatedPropertyInCompositeSchemaException {
        this.assertValidDescriptor((SchemaDescriptor)descriptor, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
        NodeExistenceConstraintDescriptor constraint = ConstraintDescriptorFactory.existsForSchema(descriptor);
        this.assertConstraintDoesNotExist(state, constraint);
        return this.schemaWriteDelegate.nodePropertyExistenceConstraintCreate(state, descriptor);
    }

    @Override
    public RelExistenceConstraintDescriptor relationshipPropertyExistenceConstraintCreate(KernelStatement state, RelationTypeSchemaDescriptor descriptor) throws AlreadyConstrainedException, CreateConstraintFailureException, RepeatedPropertyInCompositeSchemaException {
        this.assertValidDescriptor((SchemaDescriptor)descriptor, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
        RelExistenceConstraintDescriptor constraint = ConstraintDescriptorFactory.existsForSchema(descriptor);
        this.assertConstraintDoesNotExist(state, constraint);
        return this.schemaWriteDelegate.relationshipPropertyExistenceConstraintCreate(state, descriptor);
    }

    @Override
    public void constraintDrop(KernelStatement state, ConstraintDescriptor descriptor) throws DropConstraintFailureException {
        try {
            this.assertConstraintExists(state, descriptor);
        }
        catch (NoSuchConstraintException e) {
            throw new DropConstraintFailureException(descriptor, (Throwable)((Object)e));
        }
        this.schemaWriteDelegate.constraintDrop(state, descriptor);
    }

    private void assertIndexDoesNotExist(KernelStatement state, SchemaKernelException.OperationContext context, LabelSchemaDescriptor descriptor) throws AlreadyIndexedException, AlreadyConstrainedException {
        SchemaIndexDescriptor existingIndex = this.schemaReadDelegate.indexGetForSchema(state, descriptor);
        if (existingIndex != null) {
            if (existingIndex.type() == SchemaIndexDescriptor.Type.UNIQUE) {
                if (context != SchemaKernelException.OperationContext.CONSTRAINT_CREATION || this.constraintIndexHasOwner(state, existingIndex)) {
                    throw new AlreadyConstrainedException(ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)descriptor), context, new StatementTokenNameLookup(state.readOperations()));
                }
            } else {
                throw new AlreadyIndexedException(descriptor, context);
            }
        }
    }

    private boolean constraintIndexHasOwner(KernelStatement state, SchemaIndexDescriptor descriptor) {
        return this.schemaReadDelegate.indexGetOwningUniquenessConstraintId(state, descriptor) != null;
    }

    private String checkValidTokenName(String name) throws IllegalTokenNameException {
        if (name == null || name.isEmpty()) {
            throw new IllegalTokenNameException(name);
        }
        return name;
    }

    private void assertConstraintDoesNotExist(KernelStatement state, ConstraintDescriptor constraint) throws AlreadyConstrainedException {
        if (this.schemaReadDelegate.constraintExists(state, constraint)) {
            throw new AlreadyConstrainedException(constraint, SchemaKernelException.OperationContext.CONSTRAINT_CREATION, new StatementTokenNameLookup(state.readOperations()));
        }
    }

    private void assertConstraintExists(KernelStatement state, ConstraintDescriptor constraint) throws NoSuchConstraintException {
        if (!this.schemaReadDelegate.constraintExists(state, constraint)) {
            throw new NoSuchConstraintException(constraint);
        }
    }

    private void assertValidDescriptor(SchemaDescriptor descriptor, SchemaKernelException.OperationContext context) throws RepeatedPropertyInCompositeSchemaException {
        int numUnique = Arrays.stream(descriptor.getPropertyIds()).distinct().toArray().length;
        if (numUnique != descriptor.getPropertyIds().length) {
            throw new RepeatedPropertyInCompositeSchemaException(descriptor, context);
        }
    }
}

