/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema.index;

import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.internal.kernel.api.schema.SchemaUtil;

public class SchemaIndexDescriptor
implements LabelSchemaSupplier {
    private final LabelSchemaDescriptor schema;
    private final Type type;

    public SchemaIndexDescriptor(LabelSchemaDescriptor schema, Type type) {
        this.schema = schema;
        this.type = type;
    }

    public Type type() {
        return this.type;
    }

    public LabelSchemaDescriptor schema() {
        return this.schema;
    }

    public String userDescription(TokenNameLookup tokenNameLookup) {
        return String.format("Index( %s, %s )", this.type.name(), this.schema.userDescription(tokenNameLookup));
    }

    public boolean isSame(Supplier supplier) {
        return this.equals(supplier.getIndexDescriptor());
    }

    public boolean equals(Object o) {
        if (o instanceof SchemaIndexDescriptor) {
            SchemaIndexDescriptor that = (SchemaIndexDescriptor)o;
            return this.type() == that.type() && this.schema().equals(that.schema());
        }
        return false;
    }

    public int hashCode() {
        return this.type.hashCode() & this.schema.hashCode();
    }

    public String toString() {
        return this.userDescription(SchemaUtil.idTokenNameLookup);
    }

    public static Iterator<SchemaIndexDescriptor> sortByType(Iterator<SchemaIndexDescriptor> indexes) {
        List materialized = Iterators.asList(indexes);
        return Iterators.concat((Iterator[])new Iterator[]{Iterators.filter((Predicate)Filter.GENERAL, materialized.iterator()), Iterators.filter((Predicate)Filter.UNIQUE, materialized.iterator())});
    }

    public static interface Supplier {
        public SchemaIndexDescriptor getIndexDescriptor();
    }

    public static enum Filter implements Predicate<SchemaIndexDescriptor>
    {
        GENERAL{

            @Override
            public boolean test(SchemaIndexDescriptor index) {
                return index.type == Type.GENERAL;
            }
        }
        ,
        UNIQUE{

            @Override
            public boolean test(SchemaIndexDescriptor index) {
                return index.type == Type.UNIQUE;
            }
        }
        ,
        ANY{

            @Override
            public boolean test(SchemaIndexDescriptor index) {
                return true;
            }
        };

    }

    public static enum Type {
        GENERAL,
        UNIQUE;

    }
}

