/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.LongFunction;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.os.OsBeanUtil;
import org.neo4j.kernel.impl.cache.MeasureDoNothing;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.SpectrumExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.DetailLevel;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;
import org.neo4j.unsafe.impl.batchimport.stats.Stat;
import org.neo4j.unsafe.impl.batchimport.stats.StepStats;

public class OnDemandDetailsExecutionMonitor
implements ExecutionMonitor {
    private final List<StageDetails> details = new ArrayList<StageDetails>();
    private final PrintStream out;
    private final InputStream in;
    private final Map<String, Pair<String, Runnable>> actions = new HashMap<String, Pair<String, Runnable>>();
    private final MeasureDoNothing.CollectingMonitor gcBlockTime = new MeasureDoNothing.CollectingMonitor();
    private final MeasureDoNothing gcMonitor;
    private final Monitor monitor;
    private StageDetails current;
    private boolean printDetailsOnDone;

    public OnDemandDetailsExecutionMonitor(PrintStream out, InputStream in, Monitor monitor) {
        this.out = out;
        this.in = in;
        this.monitor = monitor;
        this.actions.put("i", (Pair<String, Runnable>)Pair.of((Object)"Print more detailed information", this::printDetails));
        this.actions.put("c", (Pair<String, Runnable>)Pair.of((Object)"Print more detailed information about current stage", this::printDetailsForCurrentStage));
        this.gcMonitor = new MeasureDoNothing("Importer GC monitor", this.gcBlockTime, 100L, 200L);
    }

    @Override
    public void initialize(DependencyResolver dependencyResolver) {
        this.out.println("InteractiveReporterInteractions command list (end with ENTER):");
        this.actions.forEach((key, action) -> this.out.println("  " + key + ": " + (String)action.first()));
        this.out.println();
        this.gcMonitor.start();
    }

    @Override
    public void start(StageExecution execution) {
        this.current = new StageDetails(execution, this.gcBlockTime);
        this.details.add(this.current);
    }

    @Override
    public void end(StageExecution execution, long totalTimeMillis) {
        this.current.collect();
    }

    @Override
    public void done(long totalTimeMillis, String additionalInformation) {
        if (this.printDetailsOnDone) {
            this.printDetails();
        }
        this.gcMonitor.stopMeasuring();
    }

    @Override
    public long nextCheckTime() {
        return System.currentTimeMillis() + 500L;
    }

    @Override
    public void check(StageExecution execution) {
        this.current.collect();
        this.reactToUserInput();
    }

    private void printDetails() {
        this.printDetailsHeadline();
        long totalTime = 0L;
        for (StageDetails stageDetails : this.details) {
            stageDetails.print(this.out);
            totalTime += stageDetails.totalTimeMillis;
        }
        OnDemandDetailsExecutionMonitor.printIndented(this.out, "Environment information:");
        OnDemandDetailsExecutionMonitor.printIndented(this.out, "  Free physical memory: " + Format.bytes(OsBeanUtil.getFreePhysicalMemory()));
        OnDemandDetailsExecutionMonitor.printIndented(this.out, "  Max VM memory: " + Format.bytes(Runtime.getRuntime().maxMemory()));
        OnDemandDetailsExecutionMonitor.printIndented(this.out, "  Free VM memory: " + Format.bytes(Runtime.getRuntime().freeMemory()));
        OnDemandDetailsExecutionMonitor.printIndented(this.out, "  GC block time: " + Format.duration(this.gcBlockTime.getGcBlockTime()));
        OnDemandDetailsExecutionMonitor.printIndented(this.out, "  Duration: " + Format.duration(totalTime));
        this.out.println();
    }

    private void printDetailsHeadline() {
        this.out.println();
        this.out.println();
        OnDemandDetailsExecutionMonitor.printIndented(this.out, "******** DETAILS " + Format.date() + " ********");
        this.out.println();
        this.printDetailsOnDone = true;
        this.monitor.detailsPrinted();
    }

    private void printDetailsForCurrentStage() {
        this.printDetailsHeadline();
        if (!this.details.isEmpty()) {
            this.details.get(this.details.size() - 1).print(this.out);
        }
    }

    private static void printIndented(PrintStream out, String string) {
        out.println("\t" + string);
    }

    private void reactToUserInput() {
        try {
            BufferedReader reader;
            String line;
            Pair<String, Runnable> action;
            if (this.in.available() > 0 && (action = this.actions.get(line = (reader = new BufferedReader(new InputStreamReader(System.in))).readLine())) != null) {
                ((Runnable)action.other()).run();
            }
        }
        catch (IOException e) {
            e.printStackTrace(this.out);
        }
    }

    private static class StageDetails {
        private final StageExecution execution;
        private final long startTime;
        private final MeasureDoNothing.CollectingMonitor gcBlockTime;
        private final long baseGcBlockTime;
        private long memoryUsage;
        private long ioThroughput;
        private long totalTimeMillis;
        private long stageGcBlockTime;
        private long doneBatches;

        StageDetails(StageExecution execution, MeasureDoNothing.CollectingMonitor gcBlockTime) {
            this.execution = execution;
            this.gcBlockTime = gcBlockTime;
            this.startTime = System.currentTimeMillis();
            this.baseGcBlockTime = gcBlockTime.getGcBlockTime();
        }

        void print(PrintStream out) {
            OnDemandDetailsExecutionMonitor.printIndented(out, this.execution.name());
            StringBuilder builder = new StringBuilder();
            SpectrumExecutionMonitor.printSpectrum(builder, this.execution, 100, DetailLevel.NO);
            OnDemandDetailsExecutionMonitor.printIndented(out, builder.toString());
            StageDetails.printValue(out, this.memoryUsage, "Memory usage", Format::bytes);
            StageDetails.printValue(out, this.ioThroughput, "I/O throughput", value -> Format.bytes(value) + "/s");
            StageDetails.printValue(out, this.stageGcBlockTime, "GC block time", Format::duration);
            StageDetails.printValue(out, this.totalTimeMillis, "Duration", Format::duration);
            StageDetails.printValue(out, this.doneBatches, "Done batches", String::valueOf);
            out.println();
        }

        private static void printValue(PrintStream out, long value, String description, LongFunction<String> toStringConverter) {
            if (value > 0L) {
                OnDemandDetailsExecutionMonitor.printIndented(out, description + ": " + toStringConverter.apply(value));
            }
        }

        void collect() {
            this.totalTimeMillis = System.currentTimeMillis() - this.startTime;
            this.stageGcBlockTime = this.gcBlockTime.getGcBlockTime() - this.baseGcBlockTime;
            long lastDoneBatches = this.doneBatches;
            for (Step<?> step : this.execution.steps()) {
                Stat ioStat;
                StepStats stats = step.stats();
                Stat memoryUsageStat = stats.stat(Keys.memory_usage);
                if (memoryUsageStat != null) {
                    this.memoryUsage = Long.max(this.memoryUsage, memoryUsageStat.asLong());
                }
                if ((ioStat = stats.stat(Keys.io_throughput)) != null) {
                    this.ioThroughput = ioStat.asLong();
                }
                lastDoneBatches = stats.stat(Keys.done_batches).asLong();
            }
            this.doneBatches = lastDoneBatches;
        }
    }

    static interface Monitor {
        public void detailsPrinted();
    }
}

