/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosableChannel;
import org.neo4j.string.UTF8;

public abstract class ValueType {
    private static final Map<Class<?>, ValueType> byClass = new HashMap();
    private static final Map<Byte, ValueType> byId = new HashMap<Byte, ValueType>();
    private static ValueType stringType;
    private static byte next;
    private static final ValueType arrayType;
    private final Class<?>[] classes;
    private final byte id;

    private ValueType(Class<?> ... classes) {
        byte by = next;
        next = (byte)(by + 1);
        this.id = by;
        this.classes = classes;
    }

    private static void add(ValueType type) {
        for (Class<?> cls : type.classes) {
            byClass.put(cls, type);
        }
        byId.put(type.id(), type);
    }

    public static ValueType typeOf(Object value) {
        return ValueType.typeOf(value.getClass());
    }

    public static ValueType typeOf(Class<?> cls) {
        if (cls.isArray()) {
            return arrayType;
        }
        ValueType type = byClass.get(cls);
        assert (type != null) : "Unrecognized value type " + cls;
        return type;
    }

    public static ValueType typeOf(byte id) {
        if (id == arrayType.id()) {
            return arrayType;
        }
        ValueType type = byId.get(id);
        assert (type != null) : "Unrecognized value type id " + id;
        return type;
    }

    public static ValueType stringType() {
        return stringType;
    }

    public Class<?> componentClass() {
        return this.classes[0];
    }

    public final byte id() {
        return this.id;
    }

    public abstract Object read(ReadableClosableChannel var1) throws IOException;

    public abstract int length(Object var1);

    public abstract void write(Object var1, FlushableChannel var2) throws IOException;

    static {
        ValueType.add(new ValueType(new Class[]{Boolean.TYPE, Boolean.class}){

            @Override
            public Object read(ReadableClosableChannel from) throws IOException {
                return from.get() == 0 ? Boolean.FALSE : Boolean.TRUE;
            }

            @Override
            public int length(Object value) {
                return 1;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                into.put((Boolean)value != false ? (byte)1 : 0);
            }
        });
        ValueType.add(new ValueType(new Class[]{Byte.TYPE, Byte.class}){

            @Override
            public Object read(ReadableClosableChannel from) throws IOException {
                return from.get();
            }

            @Override
            public int length(Object value) {
                return 1;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                into.put((Byte)value);
            }
        });
        ValueType.add(new ValueType(new Class[]{Short.TYPE, Short.class}){

            @Override
            public Object read(ReadableClosableChannel from) throws IOException {
                return from.getShort();
            }

            @Override
            public int length(Object value) {
                return 2;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                into.putShort((Short)value);
            }
        });
        ValueType.add(new ValueType(new Class[]{Character.TYPE, Character.class}){

            @Override
            public Object read(ReadableClosableChannel from) throws IOException {
                return Character.valueOf((char)from.getInt());
            }

            @Override
            public int length(Object value) {
                return 2;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                into.putInt(((Character)value).charValue());
            }
        });
        ValueType.add(new ValueType(new Class[]{Integer.TYPE, Integer.class}){

            @Override
            public Object read(ReadableClosableChannel from) throws IOException {
                return from.getInt();
            }

            @Override
            public int length(Object value) {
                return 4;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                into.putInt((Integer)value);
            }
        });
        ValueType.add(new ValueType(new Class[]{Long.TYPE, Long.class}){

            @Override
            public Object read(ReadableClosableChannel from) throws IOException {
                return from.getLong();
            }

            @Override
            public int length(Object value) {
                return 8;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                into.putLong((Long)value);
            }
        });
        ValueType.add(new ValueType(new Class[]{Float.TYPE, Float.class}){

            @Override
            public Object read(ReadableClosableChannel from) throws IOException {
                return Float.valueOf(from.getFloat());
            }

            @Override
            public int length(Object value) {
                return 4;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                into.putFloat(((Float)value).floatValue());
            }
        });
        stringType = new ValueType(new Class[]{String.class}){

            @Override
            public Object read(ReadableClosableChannel from) throws IOException {
                int length = from.getInt();
                byte[] bytes = new byte[length];
                from.get(bytes, length);
                return UTF8.decode((byte[])bytes);
            }

            @Override
            public int length(Object value) {
                return 4 + ((String)value).length() * 2;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                byte[] bytes = UTF8.encode((String)((String)value));
                into.putInt(bytes.length).put(bytes, bytes.length);
            }
        };
        ValueType.add(stringType);
        ValueType.add(new ValueType(new Class[]{Double.class, Double.TYPE}){

            @Override
            public Object read(ReadableClosableChannel from) throws IOException {
                return from.getDouble();
            }

            @Override
            public int length(Object value) {
                return 8;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                into.putDouble((Double)value);
            }
        });
        arrayType = new ValueType(new Class[0]){

            @Override
            public Object read(ReadableClosableChannel from) throws IOException {
                ValueType componentType = 10.typeOf(from.get());
                int length = from.getInt();
                Object value = Array.newInstance(componentType.componentClass(), length);
                for (int i = 0; i < length; ++i) {
                    Array.set(value, i, componentType.read(from));
                }
                return value;
            }

            @Override
            public int length(Object value) {
                ValueType componentType = 10.typeOf(value.getClass().getComponentType());
                int arrayLlength = Array.getLength(value);
                int length = 4;
                for (int i = 0; i < arrayLlength; ++i) {
                    length += componentType.length(Array.get(value, i));
                }
                return length;
            }

            @Override
            public void write(Object value, FlushableChannel into) throws IOException {
                ValueType componentType = 10.typeOf(value.getClass().getComponentType());
                into.put(componentType.id());
                int length = Array.getLength(value);
                into.putInt(length);
                for (int i = 0; i < length; ++i) {
                    componentType.write(Array.get(value, i), into);
                }
            }
        };
    }
}

