/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.LongSupplier;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorImpl;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdType;

public class ReadOnlyIdGeneratorFactory
implements IdGeneratorFactory {
    private final Map<IdType, IdGenerator> idGenerators = new HashMap<IdType, IdGenerator>();
    private final FileSystemAbstraction fileSystemAbstraction;

    public ReadOnlyIdGeneratorFactory() {
        this.fileSystemAbstraction = new DefaultFileSystemAbstraction();
    }

    public ReadOnlyIdGeneratorFactory(FileSystemAbstraction fileSystemAbstraction) {
        this.fileSystemAbstraction = fileSystemAbstraction;
    }

    @Override
    public IdGenerator open(File filename, IdType idType, LongSupplier highId, long maxId) {
        return this.open(filename, 0, idType, highId, maxId);
    }

    @Override
    public IdGenerator open(File filename, int grabSize, IdType idType, LongSupplier highId, long maxId) {
        ReadOnlyIdGenerator generator = new ReadOnlyIdGenerator(highId, this.fileSystemAbstraction, filename);
        this.idGenerators.put(idType, generator);
        return generator;
    }

    @Override
    public void create(File filename, long highId, boolean throwIfFileExists) {
    }

    @Override
    public IdGenerator get(IdType idType) {
        return this.idGenerators.get((Object)idType);
    }

    static class ReadOnlyIdGenerator
    implements IdGenerator {
        private final long highId;
        private final long defragCount;

        ReadOnlyIdGenerator(LongSupplier highId, FileSystemAbstraction fs, File filename) {
            if (fs != null && fs.fileExists(filename)) {
                try {
                    this.highId = IdGeneratorImpl.readHighId(fs, filename);
                    this.defragCount = IdGeneratorImpl.readDefragCount(fs, filename);
                }
                catch (IOException e) {
                    throw new UnderlyingStorageException("Failed to read id counts of the id file: " + filename, e);
                }
            } else {
                this.highId = highId.getAsLong();
                this.defragCount = 0L;
            }
        }

        @Override
        public long nextId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IdRange nextIdBatch(int size) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setHighId(long id) {
        }

        @Override
        public long getHighId() {
            return this.highId;
        }

        @Override
        public long getHighestPossibleIdInUse() {
            return this.highId - 1L;
        }

        @Override
        public void freeId(long id) {
        }

        @Override
        public void close() {
        }

        @Override
        public long getNumberOfIdsInUse() {
            return this.highId - this.defragCount;
        }

        @Override
        public long getDefragCount() {
            return this.defragCount;
        }

        @Override
        public void delete() {
        }
    }
}

