/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc.temporal;

import java.time.Clock;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.function.Supplier;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.impl.proc.temporal.TemporalFunction;
import org.neo4j.procedure.Description;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.virtual.MapValue;

@Description(value="Create a Time instant.")
class TimeFunction
extends TemporalFunction<TimeValue> {
    TimeFunction() {
        super(Neo4jTypes.NTTime);
    }

    @Override
    protected TimeValue now(Clock clock, String timezone) {
        return timezone == null ? TimeValue.now((Clock)clock) : TimeValue.now((Clock)clock, (String)timezone);
    }

    @Override
    protected TimeValue parse(TextValue value, Supplier<ZoneId> defaultZone) {
        return TimeValue.parse((TextValue)value, defaultZone);
    }

    @Override
    protected TimeValue build(MapValue map, Supplier<ZoneId> defaultZone) {
        return TimeValue.build((MapValue)map, defaultZone);
    }

    @Override
    protected TimeValue positionalCreate(AnyValue[] input) {
        if (input.length != 5) {
            throw new IllegalArgumentException("expected 5 arguments");
        }
        return TimeValue.time((int)TimeFunction.anInt("hour", input[0]), (int)TimeFunction.anInt("minute", input[1]), (int)TimeFunction.anInt("second", input[2]), (int)TimeFunction.anInt("nanos", input[3]), (String)TimeFunction.aString("offset", input[4]));
    }

    @Override
    protected TimeValue truncate(TemporalUnit unit, TemporalValue input, MapValue fields, Supplier<ZoneId> defaultZone) {
        return TimeValue.truncate((TemporalUnit)unit, (TemporalValue)input, (MapValue)fields, defaultZone);
    }
}

