/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc.temporal;

import java.time.Clock;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.function.Supplier;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.impl.proc.temporal.TemporalFunction;
import org.neo4j.procedure.Description;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.MapValue;

@Description(value="Create a LocalTime instant.")
class LocalTimeFunction
extends TemporalFunction<LocalTimeValue> {
    LocalTimeFunction() {
        super(Neo4jTypes.NTLocalTime);
    }

    @Override
    protected LocalTimeValue now(Clock clock, String timezone) {
        return timezone == null ? LocalTimeValue.now((Clock)clock) : LocalTimeValue.now((Clock)clock, (String)timezone);
    }

    @Override
    protected LocalTimeValue parse(TextValue value, Supplier<ZoneId> defaultZone) {
        return LocalTimeValue.parse((TextValue)value);
    }

    @Override
    protected LocalTimeValue build(MapValue map, Supplier<ZoneId> defaultZone) {
        return LocalTimeValue.build((MapValue)map, defaultZone);
    }

    @Override
    protected LocalTimeValue positionalCreate(AnyValue[] input) {
        if (input.length != 4) {
            throw new IllegalArgumentException("expected 4 arguments");
        }
        return LocalTimeValue.localTime((int)LocalTimeFunction.anInt("hour", input[0]), (int)LocalTimeFunction.anInt("minute", input[1]), (int)LocalTimeFunction.anInt("second", input[2]), (int)LocalTimeFunction.anInt("nanos", input[3]));
    }

    @Override
    protected LocalTimeValue truncate(TemporalUnit unit, TemporalValue input, MapValue fields, Supplier<ZoneId> defaultZone) {
        return LocalTimeValue.truncate((TemporalUnit)unit, (TemporalValue)input, (MapValue)fields, defaultZone);
    }
}

