/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

enum RelationshipReferenceEncoding {
    NONE(0L),
    FILTER(1L),
    FILTER_TX_STATE(2L),
    GROUP(3L),
    NO_OUTGOING_OF_TYPE(4L),
    NO_INCOMING_OF_TYPE(5L),
    NO_LOOP_OF_TYPE(6L);

    final long id;
    final long bits;

    private RelationshipReferenceEncoding(long id) {
        this.id = id;
        this.bits = id << 60;
    }

    static RelationshipReferenceEncoding parseEncoding(long reference) {
        if (reference == -1L) {
            return NONE;
        }
        return RelationshipReferenceEncoding.values()[RelationshipReferenceEncoding.encodingId(reference)];
    }

    private static int encodingId(long reference) {
        return (int)((reference & 0x7000000000000000L) >> 60);
    }

    static long encodeGroup(long groupId) {
        return groupId | RelationshipReferenceEncoding.GROUP.bits | Long.MIN_VALUE;
    }

    static long encodeForFiltering(long relationshipId) {
        return relationshipId | RelationshipReferenceEncoding.FILTER.bits | Long.MIN_VALUE;
    }

    static long encodeForTxStateFiltering(long relationshipId) {
        return relationshipId | RelationshipReferenceEncoding.FILTER_TX_STATE.bits | Long.MIN_VALUE;
    }

    static long encodeNoOutgoingRels(int type) {
        return (long)type | RelationshipReferenceEncoding.NO_OUTGOING_OF_TYPE.bits | Long.MIN_VALUE;
    }

    static long encodeNoIncomingRels(int type) {
        return (long)type | RelationshipReferenceEncoding.NO_INCOMING_OF_TYPE.bits | Long.MIN_VALUE;
    }

    static long encodeNoLoopRels(int type) {
        return (long)type | RelationshipReferenceEncoding.NO_LOOP_OF_TYPE.bits | Long.MIN_VALUE;
    }
}

