/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.Modes;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.InwardKernel;
import org.neo4j.kernel.impl.newapi.DefaultCursors;
import org.neo4j.kernel.impl.newapi.KernelSession;
import org.neo4j.kernel.impl.newapi.KernelToken;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageStatement;

public class NewKernel
implements Kernel,
Modes {
    private final StorageEngine engine;
    private final KernelToken token;
    private final InwardKernel kernel;
    private StorageStatement statement;
    private DefaultCursors cursors;
    private volatile boolean isRunning;

    public NewKernel(StorageEngine engine, KernelToken token, InwardKernel kernel) {
        this.engine = engine;
        this.token = token;
        this.kernel = kernel;
        this.isRunning = false;
    }

    public CursorFactory cursors() {
        assert (this.isRunning) : "kernel is not running, so it is not possible to use it";
        return this.cursors;
    }

    public KernelSession beginSession(LoginContext loginContext) {
        assert (this.isRunning) : "kernel is not running, so it is not possible to use it";
        return new KernelSession(this.token, this.kernel, loginContext);
    }

    public Modes modes() {
        return this;
    }

    public void start() {
        this.statement = this.engine.storeReadLayer().newStatement();
        this.cursors = new DefaultCursors();
        this.isRunning = true;
    }

    public void stop() {
        if (!this.isRunning) {
            throw new IllegalStateException("kernel is not running, so it is not possible to stop it");
        }
        this.statement.close();
        this.isRunning = false;
        this.cursors = null;
    }

    public boolean twoLayerTransactionState() {
        return false;
    }
}

