/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.logging;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.neo4j.io.file.Files;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.logging.AbstractLogService;
import org.neo4j.kernel.impl.logging.SimpleLogService;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.FormattedLog;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Level;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.RotatingFileOutputStreamSupplier;
import org.neo4j.scheduler.JobScheduler;

public class StoreLogService
extends AbstractLogService
implements Lifecycle {
    private final Closeable closeable;
    private final SimpleLogService logService;

    public static Builder withUserLogProvider(LogProvider userLogProvider) {
        return new Builder().withUserLogProvider(userLogProvider);
    }

    public static Builder withRotation(long internalLogRotationThreshold, long internalLogRotationDelay, int maxInternalLogArchives, JobScheduler jobScheduler) {
        return new Builder().withRotation(internalLogRotationThreshold, internalLogRotationDelay, maxInternalLogArchives, jobScheduler);
    }

    public static Builder withInternalLog(File logFile) {
        return new Builder().withInternalLog(logFile);
    }

    private StoreLogService(LogProvider userLogProvider, FileSystemAbstraction fileSystem, File internalLog, Map<String, Level> logLevels, Level defaultLevel, ZoneId logTimeZone, long internalLogRotationThreshold, long internalLogRotationDelay, int maxInternalLogArchives, Executor rotationExecutor, final Consumer<LogProvider> rotationListener) throws IOException {
        FormattedLogProvider internalLogProvider;
        if (!internalLog.getParentFile().exists()) {
            fileSystem.mkdirs(internalLog.getParentFile());
        }
        final FormattedLogProvider.Builder internalLogBuilder = FormattedLogProvider.withZoneId((ZoneId)logTimeZone).withDefaultLogLevel(defaultLevel).withLogLevels(logLevels);
        if (internalLogRotationThreshold == 0L) {
            OutputStream outputStream = Files.createOrOpenAsOuputStream((FileSystemAbstraction)fileSystem, (File)internalLog, (boolean)true);
            internalLogProvider = internalLogBuilder.toOutputStream(outputStream);
            rotationListener.accept((LogProvider)internalLogProvider);
            this.closeable = outputStream;
        } else {
            RotatingFileOutputStreamSupplier rotatingSupplier = new RotatingFileOutputStreamSupplier(fileSystem, internalLog, internalLogRotationThreshold, internalLogRotationDelay, maxInternalLogArchives, rotationExecutor, new RotatingFileOutputStreamSupplier.RotationListener(){

                public void outputFileCreated(OutputStream newStream) {
                    FormattedLogProvider logProvider = internalLogBuilder.toOutputStream(newStream);
                    ((FormattedLog)logProvider.getLog(StoreLogService.class)).info("Opened new internal log file");
                    rotationListener.accept(logProvider);
                }

                public void rotationCompleted(OutputStream newStream) {
                    FormattedLogProvider logProvider = internalLogBuilder.toOutputStream(newStream);
                    ((FormattedLog)logProvider.getLog(StoreLogService.class)).info("Rotated internal log file");
                }

                public void rotationError(Exception e, OutputStream outStream) {
                    FormattedLogProvider logProvider = internalLogBuilder.toOutputStream(outStream);
                    ((FormattedLog)logProvider.getLog(StoreLogService.class)).info("Rotation of internal log file failed:", (Throwable)e);
                }
            });
            internalLogProvider = internalLogBuilder.toOutputStream((Supplier)rotatingSupplier);
            this.closeable = rotatingSupplier;
        }
        this.logService = new SimpleLogService(userLogProvider, (LogProvider)internalLogProvider);
    }

    public void init() {
    }

    public void start() {
    }

    public void stop() {
    }

    public void shutdown() throws Throwable {
        this.closeable.close();
    }

    @Override
    public LogProvider getUserLogProvider() {
        return this.logService.getUserLogProvider();
    }

    @Override
    public LogProvider getInternalLogProvider() {
        return this.logService.getInternalLogProvider();
    }

    public static class Builder {
        private LogProvider userLogProvider = NullLogProvider.getInstance();
        private Executor rotationExecutor;
        private long internalLogRotationThreshold;
        private long internalLogRotationDelay;
        private int maxInternalLogArchives;
        private Consumer<LogProvider> rotationListener = logProvider -> {};
        private Map<String, Level> logLevels = new HashMap<String, Level>();
        private Level defaultLevel = Level.INFO;
        private ZoneId timeZoneId = ZoneOffset.UTC;
        private File debugLog;

        private Builder() {
        }

        public Builder withUserLogProvider(LogProvider userLogProvider) {
            this.userLogProvider = userLogProvider;
            return this;
        }

        public Builder withRotation(long internalLogRotationThreshold, long internalLogRotationDelay, int maxInternalLogArchives, JobScheduler jobScheduler) {
            return this.withRotation(internalLogRotationThreshold, internalLogRotationDelay, maxInternalLogArchives, jobScheduler.executor(JobScheduler.Groups.internalLogRotation));
        }

        public Builder withRotation(long internalLogRotationThreshold, long internalLogRotationDelay, int maxInternalLogArchives, Executor rotationExecutor) {
            this.internalLogRotationThreshold = internalLogRotationThreshold;
            this.internalLogRotationDelay = internalLogRotationDelay;
            this.maxInternalLogArchives = maxInternalLogArchives;
            this.rotationExecutor = rotationExecutor;
            return this;
        }

        public Builder withRotationListener(Consumer<LogProvider> rotationListener) {
            this.rotationListener = rotationListener;
            return this;
        }

        public Builder withLevel(String context, Level level) {
            this.logLevels.put(context, level);
            return this;
        }

        public Builder withTimeZone(ZoneId timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public Builder withDefaultLevel(Level defaultLevel) {
            this.defaultLevel = defaultLevel;
            return this;
        }

        public Builder withInternalLog(File logFile) {
            this.debugLog = logFile;
            return this;
        }

        public StoreLogService build(FileSystemAbstraction fileSystem) throws IOException {
            if (this.debugLog == null) {
                throw new IllegalArgumentException("Debug log can't be null; set its value using `withInternalLog`");
            }
            return new StoreLogService(this.userLogProvider, fileSystem, this.debugLog, this.logLevels, this.defaultLevel, this.timeZoneId, this.internalLogRotationThreshold, this.internalLogRotationDelay, this.maxInternalLogArchives, this.rotationExecutor, this.rotationListener);
        }
    }
}

