/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.Map;
import org.neo4j.collection.primitive.PrimitiveLongResourceCollections;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.kernel.impl.index.schema.fusion.BridgingIndexProgressor;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexUtils;
import org.neo4j.kernel.impl.index.schema.fusion.SpatialFusionIndexSampler;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;

class SpatialFusionIndexReader
implements IndexReader {
    private final Map<CoordinateReferenceSystem, IndexReader> readerMap;
    private final IndexDescriptor descriptor;

    SpatialFusionIndexReader(Map<CoordinateReferenceSystem, IndexReader> readerMap, IndexDescriptor descriptor) {
        this.readerMap = readerMap;
        this.descriptor = descriptor;
    }

    private <T> T select(Map<CoordinateReferenceSystem, T> instances, Value ... values) {
        assert (values.length == 1);
        PointValue pointValue = (PointValue)values[0];
        return instances.get(pointValue.getCoordinateReferenceSystem());
    }

    public void close() {
        FusionIndexUtils.forAll(reader -> ((IndexReader)reader).close(), this.readerMap.values().toArray());
    }

    @Override
    public long countIndexedNodes(long nodeId, Value ... propertyValues) {
        Long ans = this.selectAndRun(reader -> reader.countIndexedNodes(nodeId, propertyValues), propertyValues);
        return ans == null ? 0L : ans;
    }

    private <R> R selectAndRun(ActionableWithResult<R> actionable, Value ... values) {
        IndexReader reader = this.select(this.readerMap, values);
        if (reader != null) {
            return actionable.doIt(reader);
        }
        return null;
    }

    @Override
    public IndexSampler createSampler() {
        return new SpatialFusionIndexSampler((IndexSampler[])this.readerMap.values().stream().map(IndexReader::createSampler).toArray(IndexSampler[]::new));
    }

    @Override
    public PrimitiveLongResourceIterator query(IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        if (predicates[0] instanceof IndexQuery.ExistsPredicate) {
            PrimitiveLongResourceIterator[] iterators = new PrimitiveLongResourceIterator[this.readerMap.size()];
            int i = 0;
            for (IndexReader reader : this.readerMap.values()) {
                iterators[i++] = reader.query(predicates[0]);
            }
            return PrimitiveLongResourceCollections.concat((PrimitiveLongResourceIterator[])iterators);
        }
        NodeValueIterator nodeValueIterator = new NodeValueIterator();
        this.query(nodeValueIterator, IndexOrder.NONE, predicates);
        return nodeValueIterator;
    }

    private IndexReader selectIf(IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        if (predicates[0] instanceof IndexQuery.ExactPredicate) {
            return this.readerMap.get(((PointValue)((IndexQuery.ExactPredicate)predicates[0]).value()).getCoordinateReferenceSystem());
        }
        if (predicates[0] instanceof IndexQuery.GeometryRangePredicate) {
            return this.readerMap.get(((IndexQuery.GeometryRangePredicate)predicates[0]).crs());
        }
        return null;
    }

    @Override
    public void query(IndexProgressor.NodeValueClient cursor, IndexOrder indexOrder, IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        if (predicates[0] instanceof IndexQuery.ExistsPredicate) {
            BridgingIndexProgressor multiProgressor = new BridgingIndexProgressor(cursor, this.descriptor.schema().getPropertyIds());
            cursor.initialize(this.descriptor, multiProgressor, predicates);
            for (IndexReader reader : this.readerMap.values()) {
                reader.query(multiProgressor, indexOrder, predicates[0]);
            }
        } else {
            IndexReader reader = this.selectIf(predicates);
            if (reader != null) {
                reader.query(cursor, indexOrder, predicates);
            }
        }
    }

    @Override
    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        return false;
    }

    static interface ActionableWithResult<R> {
        public R doIt(IndexReader var1);
    }
}

