/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.SpatialKnownIndex;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexUtils;
import org.neo4j.kernel.impl.index.schema.fusion.FusionSchemaIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.SpatialFusionIndexUpdater;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;

class SpatialFusionIndexPopulator
implements IndexPopulator {
    private final long indexId;
    private final IndexDescriptor descriptor;
    private final IndexSamplingConfig samplingConfig;
    private final SpatialKnownIndex.Factory indexFactory;
    private final Map<CoordinateReferenceSystem, SpatialKnownIndex> indexMap;

    SpatialFusionIndexPopulator(Map<CoordinateReferenceSystem, SpatialKnownIndex> indexMap, long indexId, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, SpatialKnownIndex.Factory indexFactory) {
        this.indexMap = indexMap;
        this.indexId = indexId;
        this.descriptor = descriptor;
        this.samplingConfig = samplingConfig;
        this.indexFactory = indexFactory;
    }

    @Override
    public void create() throws IOException {
        if (!this.indexMap.isEmpty()) {
            throw new IOException("Trying to create a new spatial populator when the index had already been created.");
        }
    }

    @Override
    public void drop() throws IOException {
        FusionIndexUtils.forAll(entry -> ((SpatialKnownIndex)entry).drop(), this.indexMap.values().toArray());
        this.indexMap.clear();
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate<?>> updates) throws IndexEntryConflictException, IOException {
        HashMap batchMap = new HashMap();
        for (IndexEntryUpdate<?> update : updates) {
            this.selectUpdates(batchMap, update.values()).add(update);
        }
        for (CoordinateReferenceSystem crs : batchMap.keySet()) {
            SpatialKnownIndex index = this.indexFactory.selectAndCreate(this.indexMap, this.indexId, crs);
            index.startPopulation(this.descriptor, this.samplingConfig);
            index.add((Collection)batchMap.get(crs));
        }
    }

    private Collection<IndexEntryUpdate<?>> selectUpdates(Map<CoordinateReferenceSystem, Collection<IndexEntryUpdate<?>>> instances, Value ... values) {
        assert (values.length == 1);
        PointValue pointValue = (PointValue)values[0];
        return instances.computeIfAbsent(pointValue.getCoordinateReferenceSystem(), k -> new ArrayList());
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) throws IndexEntryConflictException, IOException {
    }

    @Override
    public IndexUpdater newPopulatingUpdater(PropertyAccessor accessor) {
        return SpatialFusionIndexUpdater.updaterForPopulator(this.indexMap, this.indexId, this.indexFactory, this.descriptor, this.samplingConfig);
    }

    @Override
    public void close(boolean populationCompletedSuccessfully) throws IOException {
        FusionIndexUtils.forAll(entry -> ((SpatialKnownIndex)entry).finishPopulation(populationCompletedSuccessfully), this.indexMap.values().toArray());
    }

    @Override
    public void markAsFailed(String failure) {
        FusionIndexUtils.forAll(entry -> ((SpatialKnownIndex)entry).markAsFailed(failure), this.indexMap.values().toArray());
    }

    @Override
    public void includeSample(IndexEntryUpdate<?> update) {
        Value[] values = update.values();
        assert (values.length == 1);
        CoordinateReferenceSystem crs = ((PointValue)values[0]).getCoordinateReferenceSystem();
        SpatialKnownIndex index = this.indexFactory.selectAndCreate(this.indexMap, this.indexId, crs);
        index.init(this.descriptor, this.samplingConfig);
        index.includeSample(update);
    }

    @Override
    public IndexSample sampleResult() {
        return FusionSchemaIndexProvider.combineSamples((IndexSample[])this.indexMap.values().stream().map(SpatialKnownIndex::sampleResult).toArray(IndexSample[]::new));
    }
}

