/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.NumberSchemaKey;

abstract class NumberLayout
extends Layout.Adapter<NumberSchemaKey, NativeSchemaValue> {
    NumberLayout() {
    }

    public NumberSchemaKey newKey() {
        return new NumberSchemaKey();
    }

    public NumberSchemaKey copyKey(NumberSchemaKey key, NumberSchemaKey into) {
        into.type = key.type;
        into.rawValueBits = key.rawValueBits;
        into.setEntityId(key.getEntityId());
        into.setEntityIdIsSpecialTieBreaker(key.getEntityIdIsSpecialTieBreaker());
        return into;
    }

    public NativeSchemaValue newValue() {
        return NativeSchemaValue.INSTANCE;
    }

    public int keySize(NumberSchemaKey key) {
        return 17;
    }

    public int valueSize(NativeSchemaValue value) {
        return 0;
    }

    public void writeKey(PageCursor cursor, NumberSchemaKey key) {
        cursor.putByte(key.type);
        cursor.putLong(key.rawValueBits);
        cursor.putLong(key.getEntityId());
    }

    public void writeValue(PageCursor cursor, NativeSchemaValue value) {
    }

    public void readKey(PageCursor cursor, NumberSchemaKey into, int keySize) {
        into.type = cursor.getByte();
        into.rawValueBits = cursor.getLong();
        into.setEntityId(cursor.getLong());
    }

    public void readValue(PageCursor cursor, NativeSchemaValue into, int valueSize) {
    }

    public boolean fixedSize() {
        return true;
    }
}

