/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.io.IOException;
import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.InwardKernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constaints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.monitoring.Monitors;

public class ConstraintIndexCreator {
    private final IndexingService indexingService;
    private final Supplier<InwardKernel> kernelSupplier;
    private final PropertyAccessor propertyAccessor;
    private final Monitor monitor;

    public ConstraintIndexCreator(Supplier<InwardKernel> kernelSupplier, IndexingService indexingService, PropertyAccessor propertyAccessor, Monitors monitors) {
        this.kernelSupplier = kernelSupplier;
        this.indexingService = indexingService;
        this.propertyAccessor = propertyAccessor;
        this.monitor = monitors.newMonitor(Monitor.class, new String[0]);
    }

    public long createUniquenessConstraintIndex(KernelStatement state, SchemaReadOperations schemaOps, LabelSchemaDescriptor descriptor) throws TransactionFailureException, CreateConstraintFailureException, UniquePropertyValueValidationException, AlreadyConstrainedException {
        IndexDescriptor index;
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)descriptor);
        try {
            index = this.getOrCreateUniquenessConstraintIndex(state, schemaOps, descriptor);
        }
        catch (AlreadyConstrainedException e) {
            throw e;
        }
        catch (SchemaKernelException e) {
            throw new CreateConstraintFailureException((ConstraintDescriptor)constraint, e);
        }
        boolean success = false;
        boolean reacquiredLabelLock = false;
        Locks.Client locks = state.locks().pessimistic();
        try {
            long indexId = schemaOps.indexGetCommittedId(state, index);
            IndexProxy proxy = this.indexingService.getIndexProxy(indexId);
            this.monitor.event(Thread.currentThread().getId(), 6);
            this.releaseLabelLock(locks, descriptor.getLabelId());
            this.monitor.event(Thread.currentThread().getId(), 3);
            this.monitor.event(Thread.currentThread().getId(), 2);
            this.awaitConstrainIndexPopulation(constraint, proxy);
            this.monitor.event(Thread.currentThread().getId(), 7);
            this.acquireLabelLock(state, locks, descriptor.getLabelId());
            this.monitor.event(Thread.currentThread().getId(), 4);
            reacquiredLabelLock = true;
            this.indexingService.getIndexProxy(indexId).verifyDeferredConstraints(this.propertyAccessor);
            success = true;
            long l = indexId;
            return l;
        }
        catch (SchemaRuleNotFoundException e) {
            this.monitor.log();
            throw new IllegalStateException(String.format("Index (%s) that we just created does not exist.", descriptor), (Throwable)((Object)e));
        }
        catch (IndexNotFoundKernelException e) {
            throw new TransactionFailureException(String.format("Index (%s) that we just created does not exist.", descriptor), (Throwable)((Object)e));
        }
        catch (IndexEntryConflictException e) {
            throw new UniquePropertyValueValidationException((IndexBackedConstraintDescriptor)constraint, ConstraintValidationException.Phase.VERIFICATION, e);
        }
        catch (IOException | InterruptedException e) {
            throw new CreateConstraintFailureException((ConstraintDescriptor)constraint, e);
        }
        finally {
            if (!success) {
                if (!reacquiredLabelLock) {
                    this.monitor.event(Thread.currentThread().getId(), 8);
                    this.acquireLabelLock(state, locks, descriptor.getLabelId());
                    this.monitor.event(Thread.currentThread().getId(), 5);
                }
                if (this.indexStillExists(schemaOps, state, descriptor, index)) {
                    this.dropUniquenessConstraintIndex(index);
                }
            }
        }
    }

    private boolean indexStillExists(SchemaReadOperations schemaOps, KernelStatement state, LabelSchemaDescriptor descriptor, IndexDescriptor index) {
        IndexDescriptor existingIndex = schemaOps.indexGetForSchema(state, descriptor);
        return existingIndex != null && existingIndex.equals(index);
    }

    private void acquireLabelLock(KernelStatement state, Locks.Client locks, int labelId) {
        locks.acquireExclusive(state.lockTracer(), ResourceTypes.LABEL, labelId);
    }

    private void releaseLabelLock(Locks.Client locks, int labelId) {
        locks.releaseExclusive(ResourceTypes.LABEL, labelId);
    }

    public void dropUniquenessConstraintIndex(IndexDescriptor descriptor) throws TransactionFailureException {
        try (KernelTransaction transaction = this.kernelSupplier.get().newTransaction(Transaction.Type.implicit, (LoginContext)SecurityContext.AUTH_DISABLED);
             Statement statement = transaction.acquireStatement();){
            ((KernelStatement)statement).txState().indexDoDrop(descriptor);
            transaction.success();
        }
    }

    private void awaitConstrainIndexPopulation(UniquenessConstraintDescriptor constraint, IndexProxy proxy) throws InterruptedException, UniquePropertyValueValidationException {
        try {
            proxy.awaitStoreScanCompleted();
        }
        catch (IndexPopulationFailedKernelException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IndexEntryConflictException) {
                throw new UniquePropertyValueValidationException((IndexBackedConstraintDescriptor)constraint, ConstraintValidationException.Phase.VERIFICATION, (IndexEntryConflictException)cause);
            }
            throw new UniquePropertyValueValidationException((IndexBackedConstraintDescriptor)constraint, ConstraintValidationException.Phase.VERIFICATION, cause);
        }
    }

    private IndexDescriptor getOrCreateUniquenessConstraintIndex(KernelStatement state, SchemaReadOperations schemaOps, LabelSchemaDescriptor schema) throws SchemaKernelException {
        IndexDescriptor descriptor = schemaOps.indexGetForSchema(state, schema);
        if (descriptor != null) {
            if (descriptor.type() == IndexDescriptor.Type.UNIQUE) {
                if (schemaOps.indexGetOwningUniquenessConstraintId(state, descriptor) == null) {
                    this.monitor.event(Thread.currentThread().getId(), 1);
                    return descriptor;
                }
                throw new AlreadyConstrainedException(ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)schema), SchemaKernelException.OperationContext.CONSTRAINT_CREATION, new StatementTokenNameLookup(state.readOperations()));
            }
            throw new AlreadyIndexedException(schema, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
        }
        return this.createConstraintIndex(schema);
    }

    /*
     * Exception decompiling
     */
    public IndexDescriptor createConstraintIndex(LabelSchemaDescriptor schema) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static interface Monitor {
        public static final int CREATED_INDEX = 0;
        public static final int REUSED_INDEX = 1;
        public static final int RELEASED_LOCK = 3;
        public static final int RELEASING_LOCK = 6;
        public static final int AWAITED_POPULATION = 2;
        public static final int GOT_LOCK = 4;
        public static final int AWAITING_LOCK = 7;
        public static final int GOT_LOCK_AGAIN = 5;
        public static final int AWAITING_LOCK_AGAIN = 8;

        public void event(long var1, int var3);

        public void log();
    }
}

