/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Arrays;
import java.util.function.LongPredicate;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.operations.EntityOperations;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class LookupFilter {
    private LookupFilter() {
    }

    public static PrimitiveLongIterator exactIndexMatches(PropertyAccessor accessor, PrimitiveLongIterator indexedNodeIds, IndexQuery ... predicates) {
        if (!indexedNodeIds.hasNext()) {
            return indexedNodeIds;
        }
        IndexQuery[] filteredPredicates = (IndexQuery[])Arrays.stream(predicates).filter(LookupFilter::isNumericOrGeometricPredicate).toArray(IndexQuery[]::new);
        if (filteredPredicates.length > 0) {
            LongPredicate combinedPredicate = nodeId -> {
                try {
                    for (IndexQuery predicate : filteredPredicates) {
                        int propertyKeyId = predicate.propertyKeyId();
                        Value value = accessor.getPropertyValue(nodeId, propertyKeyId);
                        if (predicate.acceptsValue(value)) continue;
                        return false;
                    }
                    return true;
                }
                catch (EntityNotFoundException ignored) {
                    return false;
                }
            };
            return PrimitiveLongCollections.filter((PrimitiveLongIterator)indexedNodeIds, (LongPredicate)combinedPredicate);
        }
        return indexedNodeIds;
    }

    public static PrimitiveLongResourceIterator exactIndexMatches(EntityOperations operations, KernelStatement state, PrimitiveLongResourceIterator indexedNodeIds, IndexQuery ... predicates) {
        if (!indexedNodeIds.hasNext()) {
            return indexedNodeIds;
        }
        IndexQuery[] filteredPredicates = (IndexQuery[])Arrays.stream(predicates).filter(LookupFilter::isNumericOrGeometricPredicate).toArray(IndexQuery[]::new);
        if (filteredPredicates.length > 0) {
            LongPredicate combinedPredicate = nodeId -> {
                try (Cursor<NodeItem> node = operations.nodeCursorById(state, nodeId);){
                    NodeItem nodeItem = (NodeItem)node.get();
                    for (IndexQuery predicate : filteredPredicates) {
                        int propertyKeyId = predicate.propertyKeyId();
                        Value value = operations.nodeGetProperty(state, nodeItem, propertyKeyId);
                        if (predicate.acceptsValue(value)) continue;
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (EntityNotFoundException ignored) {
                    return false;
                }
            };
            return PrimitiveLongCollections.filter((PrimitiveLongResourceIterator)indexedNodeIds, (LongPredicate)combinedPredicate);
        }
        return indexedNodeIds;
    }

    private static boolean isNumericOrGeometricPredicate(IndexQuery predicate) {
        IndexQuery.ExactPredicate exactPredicate;
        return predicate.type() == IndexQuery.IndexQueryType.exact ? LookupFilter.isNumberGeometryOrArray((exactPredicate = (IndexQuery.ExactPredicate)predicate).value()) : predicate.type() == IndexQuery.IndexQueryType.rangeNumeric || predicate.type() == IndexQuery.IndexQueryType.rangeGeometric;
    }

    private static boolean isNumberGeometryOrArray(Value value) {
        return Values.isNumberValue((Object)value) || Values.isGeometryValue((Value)value) || Values.isArrayValue((Value)value);
    }
}

