/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration.ssl;

import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CRLException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.operator.OperatorCreationException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ssl.LegacySslPolicyConfig;
import org.neo4j.kernel.configuration.ssl.SslPolicyConfig;
import org.neo4j.kernel.configuration.ssl.SslSystemSettings;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.ssl.ClientAuth;
import org.neo4j.ssl.PkiUtils;
import org.neo4j.ssl.SslPolicy;

public class SslPolicyLoader {
    private final Map<String, SslPolicy> policies = new ConcurrentHashMap<String, SslPolicy>();
    private final PkiUtils pkiUtils = new PkiUtils();
    private final Config config;
    private final SslProvider sslProvider;
    private SslPolicy legacyPolicy;

    private SslPolicyLoader(Config config) {
        this.config = config;
        this.sslProvider = config.get(SslSystemSettings.netty_ssl_provider);
    }

    public static SslPolicyLoader create(Config config, LogProvider logProvider) {
        SslPolicyLoader policyFactory = new SslPolicyLoader(config);
        policyFactory.load(config, logProvider.getLog(SslPolicyLoader.class));
        return policyFactory;
    }

    public SslPolicy getPolicy(String policyName) {
        if (policyName == null) {
            return null;
        }
        if (policyName.equals("legacy")) {
            return this.getOrCreateLegacyPolicy();
        }
        SslPolicy sslPolicy = this.policies.get(policyName);
        if (sslPolicy == null) {
            throw new IllegalArgumentException(String.format("Cannot find enabled SSL policy with name '%s' in the configuration", policyName));
        }
        return sslPolicy;
    }

    private SslPolicy getOrCreateLegacyPolicy() {
        if (this.legacyPolicy != null) {
            return this.legacyPolicy;
        }
        this.legacyPolicy = this.loadOrCreateLegacyPolicy();
        return this.legacyPolicy;
    }

    private SslPolicy loadOrCreateLegacyPolicy() {
        File privateKeyFile = this.config.get(LegacySslPolicyConfig.tls_key_file).getAbsoluteFile();
        File certficateFile = this.config.get(LegacySslPolicyConfig.tls_certificate_file).getAbsoluteFile();
        if (!privateKeyFile.exists() && !certficateFile.exists()) {
            String hostname = this.config.get(GraphDatabaseSettings.default_advertised_address);
            try {
                this.pkiUtils.createSelfSignedCertificate(certficateFile, privateKeyFile, hostname);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to generate private key and certificate", e);
            }
        }
        PrivateKey privateKey = this.loadPrivateKey(privateKeyFile, null);
        X509Certificate[] keyCertChain = this.loadCertificateChain(certficateFile);
        return new SslPolicy(privateKey, keyCertChain, SslPolicyConfig.TLS_VERSION_DEFAULTS, SslPolicyConfig.CIPHER_SUITES_DEFAULTS, ClientAuth.NONE, InsecureTrustManagerFactory.INSTANCE, this.sslProvider);
    }

    private void load(Config config, Log log) {
        Set<String> policyNames = config.identifiersFromGroup(SslPolicyConfig.class);
        for (String policyName : policyNames) {
            TrustManagerFactory trustManagerFactory;
            if (policyName.equals("legacy")) {
                throw new IllegalArgumentException("Legacy policy cannot be configured. Please migrate to new SSL policy system.");
            }
            SslPolicyConfig policyConfig = new SslPolicyConfig(policyName);
            File baseDirectory = config.get(policyConfig.base_directory);
            File trustedCertificatesDir = config.get(policyConfig.trusted_dir);
            File revokedCertificatesDir = config.get(policyConfig.revoked_dir);
            if (!baseDirectory.exists()) {
                throw new IllegalArgumentException(String.format("Base directory '%s' for SSL policy with name '%s' does not exist.", baseDirectory, policyName));
            }
            boolean allowKeyGeneration = config.get(policyConfig.allow_key_generation);
            File privateKeyFile = config.get(policyConfig.private_key);
            String privateKeyPassword = config.get(policyConfig.private_key_password);
            File keyCertChainFile = config.get(policyConfig.public_certificate);
            if (!privateKeyFile.exists() && !keyCertChainFile.exists() && allowKeyGeneration) {
                log.info(String.format("Generating key and self-signed certificate for SSL policy '%s'", policyName));
                String hostname = config.get(GraphDatabaseSettings.default_advertised_address);
                try {
                    this.pkiUtils.createSelfSignedCertificate(keyCertChainFile, privateKeyFile, hostname);
                    trustedCertificatesDir.mkdir();
                    revokedCertificatesDir.mkdir();
                }
                catch (IOException | GeneralSecurityException | OperatorCreationException e) {
                    throw new RuntimeException("Failed to generate private key and certificate", e);
                }
            }
            PrivateKey privateKey = this.loadPrivateKey(privateKeyFile, privateKeyPassword);
            X509Certificate[] keyCertChain = this.loadCertificateChain(keyCertChainFile);
            ClientAuth clientAuth = config.get(policyConfig.client_auth);
            boolean trustAll = config.get(policyConfig.trust_all);
            Collection<X509CRL> crls = this.getCRLs(revokedCertificatesDir);
            try {
                trustManagerFactory = this.createTrustManagerFactory(trustAll, trustedCertificatesDir, crls, clientAuth);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create trust manager based on: " + trustedCertificatesDir, e);
            }
            List<String> tlsVersions = config.get(policyConfig.tls_versions);
            List<String> ciphers = config.get(policyConfig.ciphers);
            SslPolicy sslPolicy = new SslPolicy(privateKey, keyCertChain, tlsVersions, ciphers, clientAuth, trustManagerFactory, this.sslProvider);
            log.info(String.format("Loaded SSL policy '%s' = %s", policyName, sslPolicy));
            this.policies.put(policyName, sslPolicy);
        }
    }

    private Collection<X509CRL> getCRLs(File revokedCertificatesDir) {
        CertificateFactory certificateFactory;
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>();
        File[] revocationFiles = revokedCertificatesDir.listFiles();
        if (revocationFiles == null) {
            throw new RuntimeException(String.format("Could not find or list files in revoked directory: %s", revokedCertificatesDir));
        }
        if (revocationFiles.length == 0) {
            return crls;
        }
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Could not generated certificate factory", e);
        }
        for (File crl : revocationFiles) {
            try (FileInputStream input = new FileInputStream(crl);){
                crls.addAll(certificateFactory.generateCRLs(input));
            }
            catch (IOException | CRLException e) {
                throw new RuntimeException(String.format("Could not load CRL: %s", crl), e);
            }
        }
        return crls;
    }

    private X509Certificate[] loadCertificateChain(File keyCertChainFile) {
        try {
            return this.pkiUtils.loadCertificates(keyCertChainFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load public certificate chain: " + keyCertChainFile, e);
        }
    }

    private PrivateKey loadPrivateKey(File privateKeyFile, String privateKeyPassword) {
        if (privateKeyPassword != null) {
            throw new UnsupportedOperationException("Loading private keys with passwords is not yet supported");
        }
        try {
            return this.pkiUtils.loadPrivateKey(privateKeyFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load private key: " + privateKeyFile + (privateKeyPassword == null ? "" : " (using configured password)"), e);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TrustManagerFactory createTrustManagerFactory(boolean trustAll, File trustedCertificatesDir, Collection<X509CRL> crls, ClientAuth clientAuth) throws Exception {
        if (trustAll) {
            return InsecureTrustManagerFactory.INSTANCE;
        }
        trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(null, null);
        trustedCertFiles = trustedCertificatesDir.listFiles();
        if (trustedCertFiles == null) {
            throw new RuntimeException(String.format("Could not find or list files in trusted directory: %s", new Object[]{trustedCertificatesDir}));
        }
        if (clientAuth == ClientAuth.REQUIRE && trustedCertFiles.length == 0) {
            throw new RuntimeException(String.format("Client auth is required but no trust anchors found in: %s", new Object[]{trustedCertificatesDir}));
        }
        i = 0;
        var8_8 = trustedCertFiles;
        var9_9 = var8_8.length;
        var10_11 = 0;
        while (true) {
            block20: {
                block21: {
                    if (var10_11 >= var9_9) break block21;
                    trustedCertFile = var8_8[var10_11];
                    certificateFactory = CertificateFactory.getInstance("X.509");
                    input = new FileInputStream(trustedCertFile);
                    var14_15 = null;
                    ** try [egrp 0[TRYBLOCK] [2, 3 : 140->210)] { 
lbl21:
                    // 1 sources

                    ** GOTO lbl-1000
                }
                trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                if (!crls.isEmpty()) {
                    pkixParamsBuilder = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
                    pkixParamsBuilder.setRevocationEnabled(true);
                    pkixParamsBuilder.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(crls)));
                    trustManagerFactory.init(new CertPathTrustManagerParameters(pkixParamsBuilder));
                    return trustManagerFactory;
                }
                trustManagerFactory.init(trustStore);
                return trustManagerFactory;
lbl-1000:
                // 2 sources

                {
                    while (input.available() > 0) {
                        try {
                            cert = (X509Certificate)certificateFactory.generateCertificate(input);
                            trustStore.setCertificateEntry(Integer.toString(i++), cert);
                        }
                        catch (Exception e) {
                            throw new CertificateException("Error loading certificate file: " + trustedCertFile, e);
                        }
                    }
                    break block20;
                }
lbl40:
                // 1 sources

                catch (Throwable var15_19) {
                    var14_15 = var15_19;
                    throw var15_19;
                }
lbl43:
                // 1 sources

                finally {
                    if (input != null) {
                        if (var14_15 != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable var15_18) {
                                var14_15.addSuppressed(var15_18);
                            }
                        } else {
                            input.close();
                        }
                    }
                }
            }
            ++var10_11;
        }
    }
}

