/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Base64;
import org.neo4j.string.UTF8;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public final class ArrayEncoder {
    private static final Base64.Encoder base64Encoder = Base64.getEncoder();

    private ArrayEncoder() {
        throw new AssertionError((Object)"Not for instantiation!");
    }

    public static String encode(Value array) {
        if (!Values.isArrayValue((Value)array)) {
            throw new IllegalArgumentException("Only works with arrays");
        }
        ValueEncoder encoder = new ValueEncoder();
        array.writeTo((ValueWriter)encoder);
        return encoder.result();
    }

    static class ValueEncoder
    implements ValueWriter<RuntimeException> {
        StringBuilder builder = new StringBuilder();

        ValueEncoder() {
        }

        public String result() {
            return this.builder.toString();
        }

        public void writeNull() {
        }

        public void writeBoolean(boolean value) {
            this.builder.append(value);
            this.builder.append('|');
        }

        public void writeInteger(byte value) {
            this.builder.append((double)value);
            this.builder.append('|');
        }

        public void writeInteger(short value) {
            this.builder.append((double)value);
            this.builder.append('|');
        }

        public void writeInteger(int value) {
            this.builder.append((double)value);
            this.builder.append('|');
        }

        public void writeInteger(long value) {
            this.builder.append((double)value);
            this.builder.append('|');
        }

        public void writeFloatingPoint(float value) {
            this.builder.append((double)value);
            this.builder.append('|');
        }

        public void writeFloatingPoint(double value) {
            this.builder.append(value);
            this.builder.append('|');
        }

        public void writeString(String value) {
            this.builder.append(base64Encoder.encodeToString(UTF8.encode((String)value)));
            this.builder.append('|');
        }

        public void writeString(char value) {
            this.builder.append(base64Encoder.encodeToString(UTF8.encode((String)Character.toString(value))));
            this.builder.append('|');
        }

        public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) throws RuntimeException {
            this.builder.append(crs.getTable().getTableId());
            this.builder.append(':');
            this.builder.append(crs.getCode());
            this.builder.append(':');
            int index = 0;
            for (double c : coordinate) {
                if (index > 0) {
                    this.builder.append(';');
                }
                this.builder.append(c);
                ++index;
            }
            this.builder.append('|');
        }

        public void writeDuration(long months, long days, long seconds, int nanos) throws RuntimeException {
            this.builder.append(DurationValue.duration((long)months, (long)days, (long)seconds, (long)nanos).prettyPrint());
            this.builder.append('|');
        }

        public void writeDate(long epochDay) throws RuntimeException {
            this.builder.append(DateValue.epochDate((long)epochDay).prettyPrint());
            this.builder.append('|');
        }

        public void writeLocalTime(long nanoOfDay) throws RuntimeException {
            this.builder.append(LocalTimeValue.localTime((long)nanoOfDay).prettyPrint());
            this.builder.append('|');
        }

        public void writeTime(long nanosOfDayUTC, int offsetSeconds) throws RuntimeException {
            this.builder.append(TimeValue.time((long)nanosOfDayUTC, (ZoneOffset)ZoneOffset.ofTotalSeconds(offsetSeconds)).prettyPrint());
            this.builder.append('|');
        }

        public void writeLocalDateTime(long epochSecond, int nano) throws RuntimeException {
            this.builder.append(LocalDateTimeValue.localDateTime((long)epochSecond, (long)nano).prettyPrint());
            this.builder.append('|');
        }

        public void writeDateTime(long epochSecondUTC, int nano, int offsetSeconds) throws RuntimeException {
            this.builder.append(DateTimeValue.datetime((long)epochSecondUTC, (long)nano, (ZoneOffset)ZoneOffset.ofTotalSeconds(offsetSeconds)).prettyPrint());
            this.builder.append('|');
        }

        public void writeDateTime(long epochSecondUTC, int nano, String zoneId) throws RuntimeException {
            this.builder.append(DateTimeValue.datetime((long)epochSecondUTC, (long)nano, (ZoneId)ZoneId.of(zoneId)).prettyPrint());
            this.builder.append('|');
        }

        public void beginArray(int size, ValueWriter.ArrayType arrayType) {
            if (size > 0) {
                this.builder.append(this.typeChar(arrayType));
            }
        }

        public void endArray() {
        }

        public void writeByteArray(byte[] value) {
            this.builder.append('D');
            for (byte b : value) {
                this.builder.append((double)b);
                this.builder.append('|');
            }
        }

        private char typeChar(ValueWriter.ArrayType arrayType) {
            switch (arrayType) {
                case BOOLEAN: {
                    return 'Z';
                }
                case BYTE: {
                    return 'D';
                }
                case SHORT: {
                    return 'D';
                }
                case INT: {
                    return 'D';
                }
                case LONG: {
                    return 'D';
                }
                case FLOAT: {
                    return 'D';
                }
                case DOUBLE: {
                    return 'D';
                }
                case CHAR: {
                    return 'L';
                }
                case STRING: {
                    return 'L';
                }
                case POINT: {
                    return 'P';
                }
                case ZONED_DATE_TIME: {
                    return 'T';
                }
                case LOCAL_DATE_TIME: {
                    return 'T';
                }
                case DATE: {
                    return 'T';
                }
                case ZONED_TIME: {
                    return 'T';
                }
                case LOCAL_TIME: {
                    return 'T';
                }
                case DURATION: {
                    return 'A';
                }
            }
            throw new UnsupportedOperationException("Not supported array type: " + arrayType);
        }
    }
}

