/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import org.neo4j.concurrent.BinaryLatch;
import org.neo4j.helpers.Exceptions;
import org.neo4j.io.pagecache.PageCache;

class PageCacheFlusher
extends Thread {
    private final PageCache pageCache;
    private final BinaryLatch halt = new BinaryLatch();
    private volatile boolean halted;
    private volatile Throwable error;

    PageCacheFlusher(PageCache pageCache) {
        super("PageCacheFlusher");
        this.pageCache = pageCache;
    }

    @Override
    public void run() {
        try {
            while (!this.halted) {
                try {
                    this.pageCache.flushAndForce();
                }
                catch (Throwable e) {
                    this.error = e;
                    break;
                }
            }
        }
        finally {
            this.halt.release();
        }
    }

    void halt() {
        this.halted = true;
        this.halt.await();
        if (this.error != null) {
            throw Exceptions.launderedException((Throwable)this.error);
        }
    }
}

