/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Collection;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.LongFunction;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.id.validation.IdValidator;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.IoThroughputStat;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.Key;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;
import org.neo4j.unsafe.impl.batchimport.stats.Stat;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.store.PrepareIdSequence;

public class UpdateRecordsStep<RECORD extends AbstractBaseRecord>
extends ProcessorStep<RECORD[]>
implements StatsProvider {
    protected final RecordStore<RECORD> store;
    private final int recordSize;
    private final PrepareIdSequence prepareIdSequence;
    private final LongAdder recordsUpdated = new LongAdder();

    public UpdateRecordsStep(StageControl control, Configuration config, RecordStore<RECORD> store, PrepareIdSequence prepareIdSequence) {
        super(control, "v", config, config.parallelRecordWrites() ? 0 : 1, new StatsProvider[0]);
        this.store = store;
        this.prepareIdSequence = prepareIdSequence;
        this.recordSize = store.getRecordSize();
    }

    @Override
    protected void process(RECORD[] batch, BatchSender sender) throws Throwable {
        LongFunction idSequence = (LongFunction)this.prepareIdSequence.apply(this.store);
        int recordsUpdatedInThisBatch = 0;
        for (RECORD record : batch) {
            if (record == null || !((AbstractBaseRecord)record).inUse() || IdValidator.isReservedId(((AbstractBaseRecord)record).getId())) continue;
            this.store.prepareForCommit(record, (IdSequence)idSequence.apply(((AbstractBaseRecord)record).getId()));
            this.store.updateRecord(record);
            ++recordsUpdatedInThisBatch;
        }
        this.recordsUpdated.add(recordsUpdatedInThisBatch);
    }

    @Override
    protected void collectStatsProviders(Collection<StatsProvider> into) {
        super.collectStatsProviders(into);
        into.add(this);
    }

    @Override
    public Stat stat(Key key) {
        return key == Keys.io_throughput ? new IoThroughputStat(this.startTime, this.endTime, (long)this.recordSize * this.recordsUpdated.sum()) : null;
    }

    @Override
    public Key[] keys() {
        return new Keys[]{Keys.io_throughput};
    }
}

