/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.diffsets;

import java.util.Iterator;
import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.graphdb.Resource;

public class DiffApplyingLongIterator
extends PrimitiveLongCollections.PrimitiveLongBaseIterator
implements PrimitiveLongResourceIterator {
    private final PrimitiveLongIterator source;
    private final Iterator<?> addedElementsIterator;
    private final Set<?> addedElements;
    private final Set<?> removedElements;
    protected Phase phase;

    DiffApplyingLongIterator(PrimitiveLongIterator source, Set<?> addedElements, Set<?> removedElements) {
        this.source = source;
        this.addedElements = addedElements;
        this.addedElementsIterator = addedElements.iterator();
        this.removedElements = removedElements;
        this.phase = Phase.FILTERED_SOURCE;
    }

    protected boolean fetchNext() {
        return this.phase.fetchNext(this);
    }

    private boolean computeNextFromSourceAndFilter() {
        while (this.source.hasNext()) {
            long value = this.source.next();
            if (this.removedElements.contains(value) || this.addedElements.contains(value)) continue;
            return this.next(value);
        }
        this.transitionToAddedElements();
        return this.phase.fetchNext(this);
    }

    private void transitionToAddedElements() {
        this.phase = !this.addedElementsIterator.hasNext() ? Phase.NO_ADDED_ELEMENTS : Phase.ADDED_ELEMENTS;
    }

    private boolean computeNextFromAddedElements() {
        return this.addedElementsIterator.hasNext() && this.next((Long)this.addedElementsIterator.next());
    }

    public void close() {
        if (this.source instanceof Resource) {
            ((Resource)this.source).close();
        }
    }

    protected static enum Phase {
        FILTERED_SOURCE{

            @Override
            boolean fetchNext(DiffApplyingLongIterator self) {
                return self.computeNextFromSourceAndFilter();
            }
        }
        ,
        ADDED_ELEMENTS{

            @Override
            boolean fetchNext(DiffApplyingLongIterator self) {
                return self.computeNextFromAddedElements();
            }
        }
        ,
        NO_ADDED_ELEMENTS{

            @Override
            boolean fetchNext(DiffApplyingLongIterator self) {
                return false;
            }
        };


        abstract boolean fetchNext(DiffApplyingLongIterator var1);
    }
}

