/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.concurrent;

import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.storageengine.api.lock.AcquireLockTimeoutException;
import org.neo4j.storageengine.api.lock.WaitStrategy;

public enum LockWaitStrategies implements WaitStrategy<AcquireLockTimeoutException>
{
    SPIN{

        public void apply(long iteration) throws AcquireLockTimeoutException {
        }
    }
    ,
    YIELD{

        public void apply(long iteration) throws AcquireLockTimeoutException {
            Thread.yield();
        }
    }
    ,
    INCREMENTAL_BACKOFF{
        private final int spinIterations = 1000;
        private final long multiplyUntilIteration = 1002L;

        public void apply(long iteration) throws AcquireLockTimeoutException {
            if (iteration < 1000L) {
                SPIN.apply(iteration);
                return;
            }
            try {
                if (iteration < 1002L) {
                    Thread.sleep(0L, 1 << (int)(iteration - 1000L));
                } else {
                    Thread.sleep(0L, 500);
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new AcquireLockTimeoutException(e, "Interrupted while waiting.", (Status)Status.Transaction.Interrupted);
            }
        }
    };

}

